Ascon Pilot-BIM SDK
===================
Описание
----------
Данная документация рассматривает только типы и интерфейсы специфичные для расширений к **Pilot-BIM**.
Для получения общей информации по разработке расширений для **Pilot-BIM** необходимо обращаться к документации **Ascon Pilot SDK**.
Для разработки расширений к **Pilot-BIM** в проекте расширения должен быть установлен NuGet-пакет [Ascon.Pilot.Bim.SDK](https://www.nuget.org/packages/Ascon.Pilot.Bim.SDK/), содержащий необходимые типы и интерфейсы, описанные в данной документации.
Реализация интерфейсов, связанных с встраиванием в контекстное меню, должна быть зарегистрирована через **IPilotServiceProvider** (данный интерфейс также описан в документации **Ascon Pilot SDK**) перед началом использования.

## Содержание

- [Интерфейсы для работы с вкладками группы "Информационное моделирование (BIM)"](#BimTabsInterfaces)
    - [IModelTab](#IModelTab)
    - [IServerManagerTab](#IServerManagerTab)
- [Интерфейсы для работы с представлением и состоянием модели](#ViewerInterfaces)
    - [IModelManager](#IModelManager)
    - [IModelViewer](#IModelViewer)
- [Интерфейсы для доступа к данным модели](#StorageInterfaces)
    - [IModelStorage](#IModelStorage)
- [Интерфейсы для доступа к данным журнала коллизий](#CollisionJournalInterfaces)
    - [ICollisionJournal](#ICollisionJournal)
- [Контекстное меню](#ContextMenu)
    - [Контекстное меню элементов](#IMenuContext)
- [Панель инструментов](#Toolbar)
    - [Панель инструментов вкладки информационная модель](#IToolbarManager)
- [Боковая панель вкладки "Информационная модель"](#Sidebar)
- [Нижняя панель вкладки "Информационная модель"](#BottomPanel)
- [Поиск по модели](#ModelSearchInterfaces)
    - [IModelSearchManager](#IModelSearchManager)
    - [IModelSearchService](#IModelSearchService)
    - [IModelSearchSetBuilder](#IModelSearchSetBuilder)
    - [IModelSearchGroupBuilder](#IModelSearchGroupBuilder)
    - [IModelSearchExpressionsBuilder](#IModelSearchExpressionsBuilder)
    - [Построение поисковых выражений](#ModelSearchProperty)
- [Типы данных](#DataInterfaces)
    - [IModelElementId](#IModelElementId)
	- [IModelElement](#IModelElement)
	- [ICameraPosition](#ICameraPosition)
    - [IClipPlaneProperties](#IClipPlaneProperties)
    - [IClipPlane](#IClipPlane)
    - [IPropertySet](#IPropertySet)
    - [IMeshInstance](#IMeshInstance)
    - [IMeshDefinitionId](#IMeshDefinitionId)
    - [IMeshDefinition](#IMeshDefinition)
    - [ICollision](#ICollision)
    - [IToolbarItem](#IToolbarItem)
    - [IToolbarSeparator](#IToolbarSeparator)
    - [IToolbarCommandItem](#IToolbarCommandItem)
    - [IToolbarButtonItem](#IToolbarButtonItem)
    - [IToolbarToggleItem](#IToolbarToggleItem)
    - [IToolbarMenuItem](#IToolbarMenuItem)
    - [ISidebarTab](#ISidebarTab)
    - [IBottomPanelTab](#IBottomPanelTab)
    - [PropertyKind](#PropertyKind)
    - [IModelViewerDisplaySettings](#IModelViewerDisplaySettings)
    - [IModelViewerCommonSettings](#IModelViewerCommonSettings)
    - [ModelDisplayMode](#ModelDisplayMode)
    - [ModelContext](#ModelContext)
- [Аргументы событий](#EventArgs)
    - [ModelEventArgs](#ModelEventArgs)
    - [ModelVersionEventArgs](#ModelVersionEventArgs)
    - [SelectionChangedEventArgs](#SelectionChangedEventArgs)
    - [TreeNodeEventArgs](#TreeNodeEventArgs)
	- [ModelPartEventArgs](#ModelPartEventArgs)
	- [SidebarTabSelectionChangedEventArgs](#SidebarTabSelectionChangedEventArgs)
	- [BottomPanelTabSelectionChangedEventArgs](#BottomPanelTabSelectionChangedEventArgs)
- [Константы](#Constants)
	- [Имена типов](#TypeNames)
    - [Имена атрибутов](#AttributeNames)
	- [Идентификаторы элементов панели инструментов сцены](#ViewerToolbarItemIds)
    - [Идентификаторы команд контекстного меню сцены](#ViewerContextMenuItemIds)
    - [Идентификаторы команд контекстного меню дерева](#TreeContextMenuItemIds)
    - [Идентификаторы вкладок боковой панели](#SidebarTabIds)

<a name="BimTabsInterfaces"/>
## Интерфейсы для работы с вкладками группы "Информационное моделирование (BIM)" ##

<a name="ITab"/>
### Интерфейс **ITab**
Общий интерфейс вкладок [IModelTab](#IModelTab) и [IServerManagerTab](#IServerManagerTab)

### Свойства
#### `ITab.Id`
Идентификатор вкладки
```cs
Guid Id { get; }
```

<a name="IModelTab"/>
### Интерфейс **IModelTab**
Интерфейс для работы с вкладкой Информационная модель, позволяет получать интерфейсы для работы с главной панелью инструментов и боковой панелью. Наследует интерфейс `ITab.`

### Свойства
#### `IModelTab.IModelViewer`
Интерфейс сцены модели, позволяет работать с представлением модели. Значение `null` означает, что модель не загружена.
```cs
IModelViewer ModelViewer { get; }
```

### Методы
#### `IModelTab.GetToolbarManager`
Метод позволяет получить интерфейс для работы с панелью инструментов.
```cs
IToolbarManager GetToolbarManager()
```

#### `IModelTab.GetSidebarManager`
Метод позволяет получить интерфейс для работы с боковой панелью.
```cs
ISidebarManager GetSidebarManager();
```

### События
#### `IModelTab.Disposed`
Событие оповещает о закрытии вкладки.
```cs
event EventHandler Disposed
```

<a name="IServerManagerTab"/>
### Интерфейс **IServerManagerTab**
Интерфейс представляющий вкладку "Диспетчер сервреных операций". Наследует интерфейс `ITab.`

<a name="ViewerInterfaces"/>
## Интерфейсы для работы с представлением и состоянием моделей ##

<a name="IModelManager"/>
### Интерфейс **IModelManager**
Интерфейс для работы с моделями, позволяет получать интерфейсы сцены для моделей и включает в себя события, которые оповещают о состоянии моделей.

### Методы

#### `IModelManager.GetViewers`
Метод позволяет получить интерфейсы сцены для модели.
```cs
IEnumerable<IModelViewer> GetViewers(Guid modelId)
```
где:
 - `modelId` - идентификатор модели.

### События

#### `IModelManager.ModelOpened`
Событие оповещает об открытии модели на сцене.
```cs
event EventHandler<ModelEventArgs> ModelOpened
```

#### `IModelManager.ModelLoaded`
Событие оповещает об окончании загрузки модели на сцене.
```cs
event EventHandler<ModelEventArgs> ModelLoaded
```

#### `IModelManager.ModelClosed`
Событие оповещает о закрытии модели на сцене.
```cs
event EventHandler<ModelEventArgs> ModelClosed
```
<a name="IModelViewer"/>
### Интерфейс **IModelViewer**
Интерфейс сцены модели, позволяет работать с представлением модели.

### Свойства

#### `IModelViewer.ModelId`
Идентификатор модели.
```cs
Guid ModelId { get; }
```

#### `IModelViewer.TabId`
Идентификатор вкладки.
```cs
Guid TabId { get; }
```

#### `IModelViewer.ModelVersion`
Текущая версия модели.
```cs
DateTime ModelVersion { get; }
```

### Методы

#### `IModelViewer.IsModelPartLoaded`
Метод позволяет получить флаг состояния загрузки части модели.
```cs
bool IsModelPartLoaded(Guid modelPartId)
```
где:
 - `modelPartId` - идентификатор части модели.

#### `IModelViewer.GetSelection`
Метод позволяет получить идентификаторы выбранных элементов.
```cs
IEnumerable<IModelElementId> GetSelection()
```

#### `IModelViewer.Select`
Метод позволяет добавить элементы к уже выбранным.
```cs
void Select(IEnumerable<IModelElementId> ids)
```
где:
 - `ids` - идентификаторы элементов.

#### `IModelViewer.IsolateSelection`
Метод позволяет изолировать выбранные элементы (скрыть все, кроме выбранных элементов).
```cs
void IsolateSelection()
```

#### `IModelViewer.ClearSelection`
Метод позволяет сбросить выбор элементов.
```cs
void ClearSelection()
```

#### `IModelViewer.GetVisibleElements`
Метод позволяет получить идентификаторы видимых элементов.
```cs
IEnumerable<IModelElementId> GetVisibleElements()
```

#### `IModelViewer.GetHiddenElements`
Метод позволяет получить идентификаторы скрытых элементов.
```cs

IEnumerable<IModelElementId> GetHiddenElements()
```

#### `IModelViewer.IsVisible`
Метод позволяет получить видимость элемента.
```cs
bool IsVisible(IModelElementId id)
```
где:
 - `id` - идентификатор элемента.

#### `IModelViewer.Show`
Метод позволяет сделать элементы видимыми.
```cs
void Show(IEnumerable<IModelElementId> ids)
```
где:
 - `ids` - идентификаторы элементов.

Метод позволяет сделать часть модели видимой.
```cs
void Show(Guid modelPartId)
```
где:
 - `modelPartId` - идентификатор части модели.

#### `IModelViewer.Hide`
Метод позволяет скрыть элементы.
```cs
void Hide(IEnumerable<IModelElementId> ids)
```
где:
 - `ids` - идентификаторы элементов.

Метод позволяет скрыть часть модели.
```cs
void Hide(Guid modelPartId)
```
где:
 - `modelPartId` - идентификатор части модели.

#### `IModelViewer.ExpandTreeNode`
Метод позволяет раскрыть элемент в дереве.
```cs
void ExpandTreeNode(IModelElementId id, int levels)
```
где:
 - `id` - идентификатор элемента.
 - `levels` - количество вложенных уровней элемента для раскрытия (0 - раскрывается только сам элемент).

#### `IModelViewer.CollapseTreeNode`
Метод позволяет свернуть элемент в дереве.
```cs
void CollapseTreeNode(IModelElementId id, int levels)
```
где:
 - `id` - идентификатор элемента.
 - `levels` - количество вложенных уровней элемента для сворачивания (0 - сворачивается только сам элемент).

#### `IModelViewer.SetColor`
Метод позволяет задать цвет для элементов.
```cs
void SetColor(IEnumerable<IModelElementId> ids, Color color)
```
где:
 - `ids` - идентификаторы элементов.
 - `color` - цвет.

Метод позволяет задать цвет для части модели.
```cs
void SetColor(Guid modelPartId, Color color)
```
где:
 - `modelPartId` - идентификатор части модели.
 - `color` - цвет.

#### `IModelViewer.ClearColors`
Метод позволяет сбросить цвета для элементов.
```cs
void ClearColors(IEnumerable<IModelElementId> ids)
```
где:
 - `ids` - идентификаторы элементов.

Метод позволяет сбросить цвета для части модели.
```cs
void ClearColors(Guid modelPartId)
```
где:
 - `modelPartId` - идентификатор части модели.

#### `IModelViewer.FitToView`
Метод позволяет масштабировать сцену по всем элементам.
```cs
void FitToView()
```

Метод позволяет масштабировать сцену по заданным элементам.
```cs
void FitToView(IEnumerable<IModelElementId> ids)
```
где:
 - `ids` - идентификаторы элементов.

Метод позволяет масштабировать сцену по части модели.
```cs
void FitToView(Guid modelPartId)
```
где:
 - `modelPartId` - идентификатор части модели.

#### `IModelViewer.GetCameraPosition`
Метод позволяет получить текущее положение камеры.
```cs
ICameraPosition GetCameraPosition()
```

#### `IModelViewer.SetCameraPosition`
Метод позволяет задать положение камеры.
```cs
void SetCameraPosition(ICameraPosition cameraPosition)
```
где:
 - `cameraPosition` - положение камеры.

#### `IModelViewer.GetClipPlanes`
Метод позволяет получить секущие плоскости.
```cs
IEnumerable<IClipPlane> GetClipPlanes()
```

#### `IModelViewer.AddClipPlane`
Метод позволяет добавить секущую плоскость, возвращает идентификатор созданной плоскости.
```cs
uint AddClipPlane(IClipPlaneProperties clipPlaneProperties)
```
где:
 - `clipPlaneProperties` - свойства секущей плоскости.

#### `IModelViewer.InvertClipPlane`
Метод позволяет инвертировать секущую плоскость.
```cs
void InvertClipPlane(uint clipPlaneId)
```
где:
 - `clipPlaneId` - идентификатор секущей плоскости.

#### `IModelViewer.RemoveClipPlane`
Метод позволяет удалить секущую плоскость.
```cs
void RemoveClipPlane(uint clipPlaneId)
```
где:
 - `clipPlaneId` - идентификатор секущей плоскости.

#### `IModelViewer.MakeScreenshot`
Метод позволяет сделать скриншот, возвращает массив байтов (формат - png).
```cs
byte[] MakeScreenshot(int width, int height)
```
где:
 - `width` - ширина.
 - `height` - высота.

#### `IModelViewer.GetDisplaySettings`
Метод позволяет получить текущие настройки отображения.
```cs
IModelViewerDisplaySettings GetDisplaySettings()
```

#### `IModelViewer.SetDisplaySettings`
Метод позволяет установить настройки отображения.
```cs
void SetDisplaySettings(IModelViewerDisplaySettings displaySettings)
```
где:
 - `displaySettings` - настройки отображения.

### События

#### `IModelViewer.ModelVersionAdded`
Событие оповещает о добавлении новой версии модели.
```cs
event EventHandler<ModelVersionEventArgs> ModelVersionAdded
```

#### `IModelViewer.ModelVersionChanged`
Событие оповещает об изменении текущей версии модели.
```cs
event EventHandler<ModelVersionEventArgs> ModelVersionChanged
```

#### `IModelViewer.SelectionChanged`
Событие оповещает об изменении выбора элементов.
```cs
event EventHandler<SelectionChangedEventArgs> SelectionChanged
```

#### `IModelViewer.TreeNodeExpanded`
Событие оповещает о раскрытии элемента в дереве.
```cs
event EventHandler<TreeNodeEventArgs> TreeNodeExpanded
```

#### `IModelViewer.TreeNodeCollapsed`
Событие оповещает о сворачивании элемента в дереве.
```cs
event EventHandler<TreeNodeEventArgs> TreeNodeCollapsed
```

#### `IModelViewer.ModelPartLoadingRequested`
Событие оповещает о выполнение команды загрузки части модели пользователем.
```cs
event EventHandler<ModelPartEventArgs> ModelPartLoadingRequested
```

#### `IModelViewer.ModelPartUnloadingRequested`
Событие оповещает о выполнение команды выгрузки части модели пользователем.
```cs
event EventHandler<ModelPartEventArgs> ModelPartUnloadingRequested
```

#### `IModelViewer.Disposed`
Событие оповещает о закрытии сцены.
```cs
event EventHandler Disposed
```
 
<a name="StorageInterfaces"/>
## Интерфейсы для доступа к данным модели ##

<a name="IModelStorage"/>
### Интерфейс **IModelStorage**
Интерфейс для работы с данными модели, позволяет получать версии модели, элементы модели, их свойства и геометрию.

### Свойства

#### `IModelStorage.IsLoaded`
Флаг состояния готовности к обработке вызовов пользователя.
```cs
bool IsLoaded { get; }
```

#### `IModelStorage.ModelId`
Идетификатор модели.
```cs
Guid ModelId { get; }
```

### Методы

#### `IModelStorage.GetVersions`
Метод позволяет получить все версии модели.
```cs
IEnumerable<DateTime> GetVersions()
```

#### `IModelStorage.GetModelPartsIds`
Метод позволяет получить все идентификаторы частей модели.
```cs
IEnumerable<Guid> GetModelPartsIds()
```

#### `IModelStorage.LoadRootElements`
Метод позволяет получить корневые элементы модели.
```cs
IEnumerable<IModelElement> LoadRootElements(DateTime version)
```
где:
 - `version` - версия модели.

#### `IModelStorage.LoadElements`
Метод позволяет получить все элементы для части модели.
```cs
IEnumerable<IModelElement> LoadElements(Guid modelPartId, DateTime version)
```
где:
 - `modelPartId` - идентификатор части модели.
 - `version` - версия модели.

#### `IModelStorage.LoadElement`
Метод позволяет получить элемент.
```cs
IModelElement LoadElement(IModelElementId id, DateTime version)
```
где:
 - `id` - идентификатор элемента.
 - `version` - версия модели.

#### `IModelStorage.LoadChildElements`
Метод позволяет получить дочерние элементы для элемента.
```cs
IEnumerable<IModelElement> LoadChildElements(IModelElementId parentId, DateTime version)
```
где:
 - `parentId` - идентификатор родительского элемента.
 - `version` - версия модели.

#### `IModelStorage.LoadElementProperties`
Метод позволяет получить свойства для элемента.
```cs
IEnumerable<IPropertySet> LoadElementProperties(IModelElementId id, DateTime version)
```
где:
 - `id` - идентификатор элемента.
 - `version` - версия модели.

#### `IModelStorage.LoadElementMeshInstances`
Метод позволяет получить перечисление геометрий для элемента.
```cs
IEnumerable<IMeshInstance> LoadElementMeshInstances(IModelElementId id, DateTime version)
```
где:
 - `id` - идентификатор элемента.
 - `version` - версия модели.

#### `IModelStorage.LoadMeshDefinition`
Метод позволяет получить определение геометрии (полигональную сетку).
```cs
IMeshDefinition LoadMeshDefinition(IMeshDefinitionId id)
```
где:
 - `id` - идентификатор геометрии.

### События

#### `IModelStorage.Loaded`
Событие оповещает о готовности к обработке вызовов пользователя.
```cs
event EventHandler Loaded
```

<a name="CollisionJournalInterfaces"/>
## Интерфейсы для доступа к данным журнала коллизий ##

<a name="ICollisionJournal"/>
### Интерфейс **ICollisionJournal**
Интерфейс для работы с данными журнала коллизий.

### Свойства

#### `ICollisionJournal.IsLoaded`
Флаг состояния готовности к обработке вызовов пользователя.
```cs
bool IsLoaded { get; }
```

#### `ICollisionJournal.JournalId`
Идентификатор журнала.
```cs
Guid JournalId { get; }
```

### Методы

#### `ICollisionJournal.LoadCollisions`
Метод позволяет получить все коллизии журнала.
```cs
IReadOnlyCollection<ICollision> LoadCollisions()
```

### События

#### `ICollisionJournal.Loaded`
Событие оповещает о готовности к обработке вызовов пользователя.
```cs
event EventHandler Loaded
```

<a name="ContextMenu"/>
## Контекстное меню ##
> Обращаем внимание, что при загрузке и подготовке данных, для добавляемых команд (которые сопряжены с ожиданием), необходимо придерживаться одной из следующих практик для быстрого открытия меню и своевременной обратной связи для пользователя:
1. Встроить отключенную команду (с последующим ее включением, при выполнении заданных условий);
2. Встроить подменю, с последующим наполнением его соответствующими командами;
3. Встроить команду с замещающим текстом (например, "Загрузка") на время обработки данных.

<a name="IMenuContext"/>
### Интерфейсы `IMenu<IModelElementId>` и `IMenu<ModelContext>` ###
Интерфейсы позволяют встраивать команды в контекстное меню объектов (в дереве объектов и на сцене).

За подробным описанием интерфейса `IMenu<TMenuContext>` необходимо обращаться к документации **Ascon Pilot SDK**.

<a name="Toolbar"/>
## Панель инструментов ##

<a name="IToolbarManager"/>
#### Панель инструментов вкладки "Информационная модель" ####

### Интерфейс IToolbarManager ###
Интерфейс позволяет встраивать команды в панель инструментов.

### Методы

#### `IToolbarManager.AddSeparator`
Метод позволяет добавить разделитель.
```cs
void AddSeparator(int index)
```
где:
 - `index` - индекс позиции вставки разделителя.

#### `IToolbarManager.AddToolbarButtonItem`
Метод позволяет добавить кнопку.
```cs
IToolbarButtonItem AddToolbarButtonItem(int index)
```
где:
 - `index` - индекс позиции вставки кнопки.

#### `IToolbarManager.AddToolbarToggleItem`
Метод позволяет добавить кнопку-переключатель.
```cs
IToolbarToggleItem AddToolbarToggleItem(int index)
```
где:
 - `index` - индекс позиции вставки кнопки-переключателя.

#### `IToolbarManager.AddToolbarMenuItem`
Метод позволяет добавить пункт меню.
```cs
IToolbarMenuItem AddToolbarMenuItem(int index)
```
где:
 - `index` - индекс позиции вставки пункта меню.

#### `IToolbarManager.AddToolbarMenuItem`
Метод позволяет получить все элементы панели инструментов.
```cs
IEnumerable<IToolbarItem> GetItems()
```

#### `IToolbarManager.RemoveToolbarItem`
Метод позволяет удалить команду из панели инструментов.
```cs
void RemoveToolbarItem(int index)
```
где:
 - `index` - индекс позиции удаляемой команды.

<a name="Sidebar"/>
### Боковая панель вкладки "Информационная модель"###

### Интерфейс ISidebarManager ###
Интерфейс позволяет встраивать вкладки в боковую панель.

### Методы

#### `ISidebarManager.AddTab`
Метод позволяет добавить новую вкладку.
```cs
ISidebarTab AddTab(int index, string title, byte[] icon, object view)
```
где:
 - `index` - индекс позиции вставки вкладки;
 - `title` - заголовок вкладки (отображается в всплывающей подсказке);
 - `byte[]` - иконка в формате svg;
 - `view` - контент типа FrameworkElement, который будет отображаться в качестве содержимого вкладки

#### `ISidebarManager.SelectTab`
Метод позволяет выбрать вкладку.
```cs
void SelectTab(int index)
```
где:
 - `index` - индекс позиции выбираемой вкладки;

#### `ISidebarManager.RemoveTab`
Метод позволяет удалить вкладку.
```cs
void RemoveTab(int index)
```
где:
 - `index` - индекс позиции удаляемой вкладки;

#### `ISidebarManager.GetTabs`
Метод позволяет получить все вкладки.
```cs
IEnumerable<ISidebarTab> GetTabs()
```

### События

#### `ISidebarManager.TabSelectionChanged`
Событие оповещает об изменении активной вкладки.
```cs
event EventHandler<SidebarTabSelectionChangedEventArgs> TabSelectionChanged
```

<a name="BottomPanel"/>
### Нижняя панель вкладки "Информационная модель"###

### Интерфейс IBottomPanelManager ###
Интерфейс позволяет встраивать вкладки в нижнюю панель.

### Методы

#### `IBottomPanelManager.AddBottomTab`
Метод позволяет добавить новую вкладку.
```cs
 IBottomPanelTab AddBottomTab(int index, string title, object view);
```
где:
 - `index` - индекс позиции вставки вкладки;
 - `title` - заголовок вкладки;
 - `view` - контент типа FrameworkElement, который будет отображаться в качестве содержимого вкладки

#### `IBottomPanelManager.SelectBottomTab`
Метод позволяет выбрать вкладку.
```cs
void SelectBottomTab(int index)
```
где:
 - `index` - индекс позиции выбираемой вкладки;

#### `IBottomPanelManager.RemoveBottomTab`
Метод позволяет удалить вкладку.
```cs
void RemoveBottomTab(int index)
```
где:
 - `index` - индекс позиции удаляемой вкладки;

#### `IBottomPanelManager.GetBottomTabs`
Метод позволяет получить все вкладки.
```cs
IEnumerable<IBottomPanelTab> GetBottomTabs()
```

### События

#### `IBottomPanelManager.BottomPanelTabSelectionChanged`
Событие оповещает об изменении активной вкладки.
```cs
event EventHandler<BottomTabSelectionChangedEventArgs> BottomPanelTabSelectionChanged
```

<a name="ModelSearchInterfaces"/>
## Поиск по модели ##

<a name="IModelSearchManager"/>
### Интерфейс **IModelSearchManager**
Интерфейс для получения сервиса поиска.

### Методы

#### `IModelSearchManager.GetModelSearchServiceAsync`
Метод асинхроного получения интерфейса IModelSearchService для поиска по модели.
```cs
Task<IModelSearchService> GetModelSearchServiceAsync(Guid modelId)
```
где:
 - `modelId` - идентификатор модели.

#### `IModelSearchManager.GetModelPartsSearchServiceAsync`
Метод асинхроного получения интерфейса IModelSearchService для поиска по коллекции частей модели.
```cs
Task<IModelSearchService> GetModelPartsSearchServiceAsync(IEnumerable<Guid> modelPartsIds)
```
где:
 - `modelPartsIds` - коллекция идентификаторов частей модели.

<a name="IModelSearchService"/>
### Интерфейс **IModelSearchService**
Интерфейс для выполнения поиска, данный интерфейс наследует интерфейс `IDisposable`.

### Методы

#### `IModelSearchService.AddModelPartAsync`
Метод асинхроного добавления части модели в поисковый индекс.
```cs
Task AddModelPartAsync(Guid modelPartId)
```
где:
 - `modelPartId` - идентификатор части модели.

#### `IModelSearchService.RemoveModelPart`
Метод удаления части модели из поискового индекса.
```cs
void RemoveModelPart(Guid modelPartId)
```
где:
 - `modelPartId` - идентификатор части модели.

#### `IModelSearchService.GetSearchProperties`
Метод получения коллекции свойств типа ModelSearchProperty.
```cs
IReadOnlyCollection<ModelSearchProperty> GetSearchProperties()
```

#### `IModelSearchService.GetSearchPropertiesByModelParts`
Метод получения свойств частей модели, возвращает словарь, где ключ - идентификатор части модели, значение - свойства типа ModelSearchProperty этой части модели.
```cs
IReadOnlyDictionary<Guid, IEnumerable<ModelSearchProperty>> GetSearchPropertiesByModelParts(IEnumerable<Guid> modelPartIds)
```
где:
 - `modelPartIds` - идентификаторы частей модели.

#### `IModelSearchService.Search`
Метод для запуска поиска, возвращает коллекцию подходящих под условие поиска элементов `IModelElementId`.
```cs
IEnumerable<IModelElementId> Search(SearchSetState searchSetState, int searchResultCount)
```
где:
 - `searchSetState` - поисковый запрос, сформированный с помощью построителя `IModelSearchSetBuilder`.
 - `searchResultCount` - максимальное количество найденых возвращаемых элементов.

#### `IModelSearchService.Search`
Метод для запуска поиска в определенных частях модели, возвращает коллекцию подходящих под условие поиска элементов `IModelElementId`.
```cs
IEnumerable<IModelElementId> Search(SearchSetState searchSetState, IEnumerable<Guid> modelPartIdsToSearchIn, int searchResultCount)
```
где:
 - `searchSetState` - поисковый запрос, сформированный с помощью построителя `IModelSearchSetBuilder`.
 - `modelPartIdsToSearchIn` - коллекция идентификаторов частей модели, по которым необходимо выполнить поиск. Если коллекция принимает значние null, поиск будет выполнен по всей модели.
 - `searchResultCount` - максимальное количество найденых возвращаемых элементов.

<a name="IModelSearchSetBuilder"/>
### Интерфейс **IModelSearchSetBuilder**
Интерфейс для конструирования поискового запроса. Для получения данного интерфейса необходимо воспользоваться статическим методом `IModelSearchSetBuilder ModelSearchSetBuilder.CreateBuilder(SearchSetLogicalOperator.And)`, где:
где `SearchSetLogicalOperator` логический оператор запроса.

### Методы

#### `IModelSearchSetBuilder.AddExpressions`
Метод добавления условий поиска, сформированных с помощью построителя выражений `IModelSearchExpressionsBuilder`
```cs
IModelSearchSetBuilder IModelSearchSetBuilder.AddExpressions(IModelSearchExpressionsBuilder expressionBuilder)
```
где:
 - `expressionBuilder` - сформированный построитель выражений для поиска.

#### `IModelSearchSetBuilder.NewGroup`
Метод добавления новой пустой группы для добавления в нее условий поиска. Возвращает экземпляр построителя выражений `IModelSearchGroupBuilder`.
```cs
IModelSearchGroupBuilder NewGroup(SearchSetLogicalOperator logicalOperator)
```
где:
 - `logicalOperator` - логический оператор для группы.

#### `IModelSearchSetBuilder.Build`
Метод получения результирующего поискового запроса для передачи в качестве аргумента в метод `IModelSearchService.Search`.
```cs
SearchSetState Build()
```

<a name="IModelSearchGroupBuilder"/>
### Интерфейс **IModelSearchGroupBuilder**
Интерфейс конструирования поисковых запросов для группы.

### Методы

#### `IModelSearchGroupBuilder.AddExpressions`
Метод добавления условий поиска, сформированных с помощью построителя выражений `IModelSearchExpressionsBuilder`
```cs
IModelSearchGroupBuilder IModelSearchGroupBuilder.AddExpressions(IModelSearchExpressionsBuilder expressionBuilder)
```
где:
 - `expressionBuilder` - сформированный построитель выражений для поиска.

#### `IModelSearchSetBuilder.NewGroup`
Метод добавления новой пустой группы для добавления в нее условий поиска. Возвращает экземпляр построителя выражений `IModelSearchGroupBuilder`.
```cs
IModelSearchGroupBuilder NewGroup(SearchSetLogicalOperator logicalOperator)
```
где:
 - `logicalOperator` - логический оператор для группы.

<a name="IModelSearchExpressionsBuilder"/>
### Интерфейс **IModelSearchExpressionsBuilder**
Интерфейс для конструирования поискового выражения. Для получения данного интерфейса необходимо воспользоваться статическим методом `ModelSearchExpressionsBuilder.CreateBuilder()`.

### Методы

#### `IModelSearchExpressionsBuilder.AddExpression`
Метод добавления условия поиска.
```cs
IModelSearchExpressionsBuilder IModelSearchExpressionsBuilder.AddExpression(IModelSearchExpression expression)
```
где:
 - `expression` - сформированное с помощью статического класса `ModelProperty` поисковое выражение.

<a name="ModelSearchProperty"/>
### Построение поисковых выражений

##### ModelProperty.GlobalIdReadable
Используйте это свойство, чтобы задать поиск по определенному идентификатору элемента.
Например:
```cs
var id = new Guid("27f622ac-13af-4037-916b-f1116d69697d");
var searchExpressionsBuilder = ModelSearchExpressionsBuilder.CreateBuilder();
searchExpressionsBuilder.AddExpression(ModelProperty.GlobalIdReadable.EqualTo(id));
```

##### ModelProperty.Name
Используйте это свойство, чтобы задать поиск по определенному имени элемента.
Например:
```cs
var searchExpressionsBuilder = ModelSearchExpressionsBuilder.CreateBuilder();
searchExpressionsBuilder.AddExpression(ModelProperty.Name.EqualTo("Базовая стена:Типовой - 200мм:284316"));
```

##### ModelProperty.Type
Используйте это свойство, чтобы задать поиск по определенному типу элемента.
Например:
```cs
var searchExpressionsBuilder = ModelSearchExpressionsBuilder.CreateBuilder();
searchExpressionsBuilder.AddExpression(ModelProperty.Type.EqualTo("IfcWindow"));
```

##### ModelProperty.ModelPartId
Используйте это свойство, чтобы задать поиск по определенному идентификатору части модели.
Например:
```cs
var id  = new Guid("79f4b1fd-ba99-429f-9d67-31959ddec6ab");
var searchExpressionsBuilder = ModelSearchExpressionsBuilder.CreateBuilder();
searchExpressionsBuilder.AddExpression(ModelProperty.ModelPartId.EqualTo(id));
```

##### ModelProperty.ModelPartName
Используйте это свойство, чтобы задать поиск с использованием наименования части модели.
Например:
```cs
var searchExpressionsBuilder = ModelSearchExpressionsBuilder.CreateBuilder();
searchExpressionsBuilder.AddExpression(ModelProperty.ModelPartName.Contains("Проект_"));
```

##### ModelProperty.PartOf
Используйте это свойство, чтобы найти все дочерние элементы.
Например:
```cs
var id  = new Guid("79f4b1fd-ba99-429f-9d67-31959ddec6ab"); // Идентификатор элемента "Этаж 1"
var searchExpressionsBuilder = ModelSearchExpressionsBuilder.CreateBuilder();
searchExpressionsBuilder.AddExpression(ModelProperty.PartOf.EqualTo(id));
```

##### ModelProperty.WithName(string name, string categoryName, PropertyDataType kind)
где:
 - `name` - наименование свойства,
 - `categoryName` - наименование категории; в качастве наименования категории возможно передать значение null, тогда поиск выполнится с условием **<Все категории>**,
 - `kind` - тип данных свойства.

Используйте этот метод для составления выражения, по свойству:
```cs
var searchExpressionsBuilder = ModelSearchExpressionsBuilder.CreateBuilder();
searchExpressionsBuilder.AddExpression(ModelProperty.WithName("Width", "Qto_WallBaseQuantities", PropertyDataType.Double).GreaterThanOrEqual(200d));
```
Или свойству полученному с помощью метода `IModelSearchService.GetSearchProperties()`:
```cs
var doubleProperty = searchService.GetSearchProperties().First(x => 
				   x.CategoryName.Equals("Qto_WallBaseQuantities", StringComparison.OrdinalIgnoreCase) 
				&& x.Name.Equals("Width", StringComparison.OrdinalIgnoreCase, StringComparison.OrdinalIgnoreCase));
var searchExpressionsBuilder = ModelSearchExpressionsBuilder.CreateBuilder();
searchExpressionsBuilder.AddExpression(doubleProperty.GreaterThanOrEqual(200d));
```

### Условия поиска

##### Условия Defined и NotDefined
`Defined` - для поиска элементов с заданным свойством;
`NotDefined` - для поиска элементов с не заданным свойством.
```cs
IModelSearchExpression Defined();
IModelSearchExpression NotDefined();
```
Например:
```cs
var tagProperty = ModelProperty.WithName(searchService.GetSearchProperties().First(x => x.CategoryName.Equals("Pset_ElementInformation", StringComparison.OrdinalIgnoreCase)
				&& x.Name.Equals("Tag", StringComparison.OrdinalIgnoreCase, StringComparison.OrdinalIgnoreCase), null, PropertyDataType.String);
var searchExpressionsBuilder = ModelSearchExpressionsBuilder.CreateBuilder();
searchExpressionsBuilder.AddExpression(tagProperty.Defined());
```

##### Условия EqualTo и NotEqualTo
`EqualTo` - равно;
`NotEqualTo` - не равно.
Данное условие доступно для типов данных `Guid`, `string`, `double`, `bool`, `DateTime` и `long`.
```cs
IModelSearchExpression EqualTo(T value);
IModelSearchExpression NotEqualTo(T value);
```
Например:
```cs
var searchExpressionsBuilder = ModelSearchExpressionsBuilder.CreateBuilder();
searchExpressionsBuilder.AddExpression(ModelProperty.Type.EqualTo("IfcProject"));
```

##### Условия Contains и NotContains
`Contains` - содержит;
`NotContains` - не содержит.
Данное условие доступно для типа данных `string`.
```cs
IModelSearchExpression Contains(T value);
IModelSearchExpression NotContains(T value);
```
Например:
```cs
var searchExpressionsBuilder = ModelSearchExpressionsBuilder.CreateBuilder();
searchExpressionsBuilder.AddExpression(ModelProperty.Type.Contains("Project"));
```

##### Условия GreaterThanOrEqual, LessThanOrEqual, GreaterThan, LessThan
`GreaterThanOrEqual` - больше или равно;
`LessThanOrEqual` - меньше или равно;
`GreaterThan` - больше;
`LessThan` - меньше;
Данное условие доступно для типов данных `double`, `DateTime` и `long`.
```cs
IModelSearchExpression GreaterThanOrEqual(T value);
IModelSearchExpression LessThanOrEqual(T value);
IModelSearchExpression GreaterThan(T value);
IModelSearchExpression LessThan(T value);
```
Например:
```cs
var doubleProperty = searchService.GetSearchProperties().First(x => 
x.CategoryName.Equals("Qto_WallBaseQuantities", StringComparison.OrdinalIgnoreCase) 
				&& x.Name.Equals("Width", StringComparison.OrdinalIgnoreCase, StringComparison.OrdinalIgnoreCase));
var searchExpressionsBuilder = ModelSearchExpressionsBuilder.CreateBuilder();
searchExpressionsBuilder
					.AddExpression(ModelProperty.Type.EqualTo("IfcWall"))
					.AddExpression(doubleProperty.GreaterThanOrEqual(200d));
```

##### Условие Wildcard
Поиск значений соответствующих шаблону, поддерживает одиночный(?) и многократный (*) подстановочные символы. Данное условие доступно для типа данных `string`.
```cs
IModelSearchExpression Wildcard(string pattern);
```
Например:
```cs
var searchExpressionsBuilder = ModelSearchExpressionsBuilder.CreateBuilder();
expressionsBuilder.AddExpression(ModelProperty.Type.Wildcard("*cWa??"));
```

##### Условие Regexp
Поиск значений соответствующих шаблону регулярного выражения. Данное условие доступно для типа данных `string`.
```cs
IModelSearchExpression Regexp(string regexpPattern);
```
Например:
```cs
var searchExpressionsBuilder = ModelSearchExpressionsBuilder.CreateBuilder();
expressionsBuilder.AddExpression(ModelProperty.Type.Regexp("^Ifc(Wall|Window)$"));
```

<a name="DataInterfaces"/>
### Типы данных ###

<a name="IModelElementId"/>
### Интерфейс **IModelElementId**

Интерфейс идентификатора элемента.
Описание свойств интерфейса:
 - `Guid ElementId { get; }` - идентификатор элемента;
 - `Guid ModelPartId { get; }` - идентификатор части модели.

<a name="IModelElement"/>
### Интерфейс **IModelElement**

Интерфейс элемента.
Описание свойств интерфейса:
 - `IModelElementId Id { get; }` - интерфейс идентификатора элемента;
 - `IModelElementId ParentId { get; }` - интерфейс идентификатора родительского элемента;
 - `string Name { get; }` - имя элемента;
 - `string Type { get; }` - тип элемента;
 - `DateTime Version { get; }` - версия элемента.

<a name="ICameraPosition"/>
### Интерфейс **ICameraPosition**

Интерфейс положения камеры.
Описание свойств интерфейса:
 - `float X { get; }` - координата X положения камеры;
 - `float Y { get; }` - координата Y положения камеры;
 - `float Z { get; }` - координата Z положения камеры;
 - `float EyeX { get; }` - координата X точки взгляда камеры;
 - `float EyeY { get; }` - координата Y точки взгляда камеры;
 - `float EyeZ { get; }` - координата Z точки взгляда камеры;
 - `float PivotX { get; }` - координата X опорной точки вращения камеры;
 - `float PivotY { get; }` - координата Y опорной точки вращения камеры;
 - `float PivotZ { get; }` - координата Z опорной точки вращения камеры;
 - `float Angle { get; }` - угол обзора камеры (в радианах).

<a name="IClipPlaneProperties"/>
### Интерфейс **IClipPlaneProperties**

Интерфейс свойств секущей плоскости.
Описание свойств интерфейса:
 - `float X { get; }` - координата X положения секущей плоскости;
 - `float Y { get; }` - координата Y положения секущей плоскости;
 - `float Z { get; }` - координата Z положения секущей плоскости;
 - `float NormalX { get; }` - координата X нормализованного вектора нормали;
 - `float NormalY { get; }` - координата Y нормализованного вектора нормали;
 - `float NormalZ { get; }` - координата Z нормализованного вектора нормали.

<a name="IClipPlane"/>
### Интерфейс **IClipPlane**

Интерфейс секущей плоскости.
Описание свойств интерфейса:
 - `uint Id { get; }` - идентификатор секущей плоскости;
 - `IClipPlaneProperties Properties { get; }` - интерфейс свойств секущей плоскости.

<a name="IProperty"/>
### Интерфейс **IProperty**

Интерфейс свойства элемента.
Описание свойств интерфейса:
 - `string Name { get; }` - имя свойства;
 - `string Unit { get; }` - единицы измерения свойства;
 - `object Value { get; }` - значение свойства.

<a name="IPropertySet"/>
### Интерфейс **IPropertySet**

Интерфейс группы свойств элемента.
Описание свойств интерфейса:
 - `string Name { get; }` - имя группы свойств;
 - `IEnumerable<IProperty> Properties { get; }` - перечисление интерфейсов свойств;
 - `string Type { get; }` - тип группы свойств.

<a name="IMeshInstance"/>
### Интерфейс **IMeshInstance**

Интерфейс геометрии элемента.
Описание свойств интерфейса:
 - `IMeshDefinitionId MeshDefinitionId { get; }` - интерфейс идентификатора определения геометрии;
 - `Color Color { get; }` - цвет геометрии;
 - `Matrix4x4 Placement { get; }` - положение геометрии.

<a name="IMeshDefinitionId"/>
### Интерфейс **IMeshDefinitionId**

Интерфейс идентификатора определения геометрии.
Описание свойств интерфейса:
 - `Guid MeshId { get; }` - идентификатор геометрии;
 - `Guid ModelPartId { get; }` - идентификатор части модели.

<a name="IMeshDefinition"/>
### Интерфейс **IMeshDefinition**

Интерфейс определения геометрии (полигональная сетка).
Описание свойств интерфейса:
 - `IEnumerable<float> Vertices { get; }` - перечисление вершин геометрии;
 - `IEnumerable<float> Normals { get; }` - перечисление нормалей геометрии;
 - `IEnumerable<uint> Indices { get; }` - перечисление индексов геометрии;
 - `IEnumerable<uint> EdgeIndices { get; }` - перечисление индексов ребер геометрии.

<a name="ICollision"/>
### Интерфейс **ICollision**

Интерфейс определения коллизии.
Описание свойств интерфейса:
 - `Guid Id { get; }` - идентификатор коллизии;
 - `IModelElementId FirstElementId { get; }` - идентификатор первого элемента коллизии;
 - `IModelElementId SecondElementId { get; }` - идентификатор второго элемента коллизии;
 - `DateTime FoundDateTime { get; }` - дата и время обнаружения коллизии;
 - `IMeshDefinition MeshDefinition { get; }` - определение геометрии (полигональной сетки) тела пересечения;
 - `double[] Transformation { get; }` - матрица трансформации тела пересечения;
 - `Guid StateId { get; }` - идентификатор состояния коллизии;
 - `string Name { get; }` - имя коллизии;
 - `double Volume { get; }` - объем тела пересечения. Объем может быть равен -1, если его не удалось посчитать.

<a name="IToolbarItem"/>
### Интерфейс **IToolbarItem**

Базовый интерфейс элемента панели инструментов.
Описание свойств интерфейса:
 - `string Id { get; }` - уникальный идентификатор элемента.

<a name="IToolbarSeparator"/>
### Интерфейс **IToolbarSeparator**

Интерфейс идентификации элемента типа "Разделитель" панели инструментов. Наследует интерфейс `IToolbarItem.`

<a name="IToolbarCommandItem"/>
### Интерфейс **IToolbarCommandItem**

Интерфейс, описывающий элемент панели инструментов. Наследует интерфейс `IToolbarItem.`
Описание свойств интерфейса:
 - `string Title { get; set; }` - наименование элемента;
 - `byte[] Icon { set; }` - иконка в формате svg;
 - `bool IsEnabled { get; set; }` - значение доступности элемента;
 - `bool IsTitleVisible { get; set; }` - флаг отображения наименования;
 - `string Tooltip { get; set; }` - всплывающая подсказка.

<a name="IToolbarButtonItem"/>
### Интерфейс **IToolbarButtonItem**

Интерфейс, описывающий кнопку панели инструментов. Наследует интерфейс `IToolbarCommandItem`
Описание свойств интерфейса:
 - `Action OnClick { set; }` - делегат, который вызывается при нажатии на кнопку.

<a name="IToolbarToggleItem"/>
### Интерфейс **IToolbarToggleItem**

Интерфейс, описывающий кнопку-переключатель панели инструментов. Наследует интерфейс `IToolbarCommandItem.`
Описание свойств интерфейса:
 - `bool IsChecked { get; set; }` - значение состояния;
 - `Action<bool> OnClick { set; }` - делегат, который вызывается при нажатии на кнопку.

<a name="IToolbarMenuItem"/>
### Интерфейс **IToolbarMenuItem**

Интерфейс, описывающий пункт меню панели инструментов. Наследует интерфейсы `IToolbarCommandItem` и `IToolbarManager.`

<a name="ISidebarTab"/>
### Интерфейс **ISidebarTab**

Интерфейс, описывающий вкладку боковой панели.
Описание свойств интерфейса:
 - `string Id { get; }` - уникальный идентификатор вкладки;
 - `string Title { get; }` - наименование вкладки;
 - `bool IsSelected { get; }` - флаг, указывающий на состояние: выбрана вкладка или нет;
 - `bool IsVisible { get; set; }` - флаг, управляющий видимостью вкладки на боковой панели.

 <a name="IBottomPanelTab"/>
### Интерфейс **IBottomPanelTab**

Интерфейс, описывающий вкладку нижней панели.
Описание свойств интерфейса:
 - `string Id { get; }` - уникальный идентификатор вкладки;
 - `string Title { get; }` - наименование вкладки;
 - `bool IsSelected { get; }` - флаг, указывающий на состояние: выбрана вкладка или нет;
 - `bool IsVisible { get; set; }` - флаг, управляющий видимостью вкладки нижней панели.

<a name="PropertyKind"/>
### Перечисление **PropertyKind**

Перечисление типов данных свойств модели.
Описание:
 - `PropertyKind.String` - строка;
 - `PropertyKind.Double` - число с плавающей запятой;
 - `PropertyKind.DateTime` - время;
 - `PropertyKind.Bool` - логическое значение.

<a name="IModelViewerDisplaySettings"/>
### Интерфейс **IModelViewerDisplaySettings**

Интерфейс настроек отображения модели.
Описание свойств интерфейса:
 - `IModelViewerCommonSettings ModelViewerCommonSettings { get; }` - общие настройки;

<a name="IModelViewerCommonSettings"/>
### Интерфейс **IModelViewerCommonSettings**

Интерфейс общих настроек.
Описание свойств интерфейса:
 - `bool ShowTelemetry { get; set; }` - отображать телеметрию;
 - `bool ShowAxes { get; set; }` - отображать оси;
 - `bool UseCameraAnimation { get; set; }` - использовать анимацию камеры;
 - `bool ShowViewCube { get; set; }` - отображать видивой куб;
 - `bool HideSmallObjects { get; set; }` - скрывать меленькие объекты;
 - `int SmallObjectPixelsSize { get; set; }` - размер маленького объекта в пикселях;
 - `float GridLineProjectionLength { get; set; }` - длина выступа метки линии сетки в мм;
 - `ModelDisplayMode ModelDisplayMode { get; set; }` - режим отображения модели;
 - `bool HideEdgesWithMouseNavigation { get; set; }` - скрывать ребра при навигации;
 - `bool AmbientOcclusion { get; set; }` - глобальное освещение;
 - `bool LightSources { get; set; }` - источники света;
 - `bool MultisampleAntiAliasing { get; set; }` - сглаживание граней и ребер;
 - `bool HideSmallObjectsWithMouseNavigation { get; set; }` - скрывать маленькие объекты при навигации.

<a name="ModelDisplayMode"/>
### Перечисление **ModelDisplayMode**

Перечисление режимов отображения модели.
Описание:
 - `ModelDisplayMode.FacesAndEdges` - грани и ребра;
 - `ModelDisplayMode.FacesOnly` - только грани;
 - `ModelDisplayMode.EdgesOnly` - только ребра (недоступно при установке `HideEdgesWithMouseNavigation = true`).

<a name="ModelContext"/>
### Класс **ModelContext**

Контекст построения контестного меню дерева объектов и сцены.
Описание свойств класса:
 - `IEnumerable<IModelElementId> SelectedElements { get; }` - выбранные элементы;
 - `IModelViewer ModelViewer { get; }` - интерфейс IModelViewer.

<a name="EventArgs"/>
## Аргументы событий ##

<a name="ModelEventArgs"/>
### Аргументы **ModelEventArgs**

Аргументы событий изменения состояния модели.
Описание свойств аргументов:
 - `IModelViewer Viewer { get; }` - интерфейс сцены модели.

<a name="ModelVersionEventArgs"/>
### Аргументы **ModelVersionEventArgs**

Аргументы событий изменения версий модели.
Описание свойств аргументов:
 - `DateTime Version { get; }` - версия модели.

<a name="SelectionChangedEventArgs"/>
### Аргументы **SelectionChangedEventArgs**

Аргументы событий изменения выбранных элементов.
Описание свойств аргументов:
 - `IEnumerable<IModelElementId> SelectedIds { get; }` - перечисление интерфейсов идентификаторов выбранных элементов.

<a name="TreeNodeEventArgs"/>
### Аргументы **TreeNodeEventArgs**

Аргументы событий изменения состояния элемента в дереве элементов.
Описание свойств аргументов:
 - `IModelElementId Id { get; }` - интерфейс идентификатора элемента.

<a name="ModelPartEventArgs"/>
### Аргументы **ModelPartEventArgs**

Аргументы событий загрузки/выгрузки частей модели.
Описание свойств аргументов:
 - `Guid Id { get; }` - идентификатор части модели.

<a name="SidebarTabSelectionChangedEventArgs"/>
### Аргументы **SidebarTabSelectionChangedEventArgs**

Аргументы событий изменения выбранной вкладки боковой панели.
Описание свойств аргументов:
 - `ISidebarTab SelectedTab { get; }` - выбранная вкладка.
 - `ISidebarTab UnselectedTab { get; }` - предыдущая выбранная вкладка.

<a name="BottomPanelTabSelectionChangedEventArgs"/>
### Аргументы **BottomPanelTabSelectionChangedEventArgs**

Аргументы событий изменения выбранной вкладки нижней панели.
Описание свойств аргументов:
 - `IBottomPanelTab SelectedTab { get; }` - выбранная вкладка.
 - `IBottomPanelTab UnselectedTab { get; }` - предыдущая выбранная вкладка

<a name="Constants"/>
## Константы ##

<a name="TypeNames"/>
####Имена типов####

Тип **Консолидированная BIM-модель**.
```cs
public static string CoordinationModel = "bim_coordinationModel";
```
Тип **Часть консолидированной модели**.
```cs
public static string ModelPart = "bim_modelPart";
```
Тип **Папка замечаний к модели**.
```cs
public static string RemarksFolder = "bim_modelRemarksFolder";
```
Тип **Папка точек взгляда модели**.
```cs
public static string ViewPointsFolder = "bim_viewPointsFolder";
```
Тип **Папка поисковых наборов**.
```cs
public static string SearchSetFolder = "bim_searchSetsFolder";
```
Тип **Точка взгляда модели**.
```cs
public static string ViewPoint = "bim_viewPoint";
```
Тип **Поисковый набор**.
```cs
public static string SearchSet = "bim_searchSet";
```

<a name="AttributeNames"/>
####Имена атрибутов####

Атрибут **Имя**.
```cs
public static string Name = "name";
```
Атрибут **Поисковый запрос** объекта типа **Поисковый набор**.
```cs
public static string SearchRequest = "searchRequest";
```

<a name="ViewerToolbarItemIds"/>
####Идентификаторы элементов панели инструментов сцены####

Идентификатор элемента **Открыть проект**.
```cs
public static string OpenProject = "tbiOpenProject";
```
Идентификатор элемента **Настройки отображения**.
```cs
public static string ViewerOptions = "tbiOptions";
```
Идентификатор элемента **Масштабировать по всем объектам**.
```cs
public static string ZoomToFit = "tbiZoomToFit";
```
Идентификатор элемента **Отображать скрытые объекты**.
```cs
public static string ToggleHiddenNodesVisibilityMode = "tbiToggleHiddenNodesVisibilityMode";
```
Идентификатор элемента **Отображать замечания**.
```cs
public static string ToggleRemarksVisibility = "tbiToggleRemarksVisibility";
```
Базовый идентификатор элементов добавления замечаний разных типов.
```cs
public static string AddRemarkBase = "tbiAddRemark";
```
Идентификатор элемента **Создать новую секущую плоскость**.
```cs
public static string AddClipPlane = "tbiAddClipPlane";
```
Идентификатор элемента **Инвертировать выбраную секущую плоскость**.
```cs
public static string InvertSelectedClipPlane = "tbiInvertSelectedClipPlane";
```
Идентификатор элемента **Инструменты измерений**.
```cs
public static string MeasurementTools = "tbiMeasurementTools";
```
Идентификатор элемента измерения **По двум точкам**.
```cs
public static string TwoPointsMeasure = "tbiTwoPointsMeasure";
```
Идентификатор элемента измерения **Длина ребра**.
```cs
public static string EdgesMeasure = "tbiEdgesMeasure";
```
Идентификатор элемента измерения **Между точкой и плоскостью**.
```cs
public static string PointAndPlaneMeasure = "tbiPointAndPlaneMeasure";
```
Идентификатор элемента **Настройки инструментов измерения**.
```cs
public static string MeasurementToolsOptions = "tbiMeasurementToolsOptions";
```
Идентификатор элемента **Удалить выбранные элементы**.
```cs
public static string DeleteSelectedElement = "tbiDeleteSelected";
```
Идентификатор элемента **Фото Pilot-BIM Camera**.
```cs
public static string BimCameraMenu = "tbiRealViewMenu";
```
Идентификатор элемента **Изменить связь с папкой фото на диске...**.
```cs
public static string BimCameraChangeRootFolder = "tbiRealViewChangeRootFolder";
```
Идентификатор элемента **Удалить связь с папкой фото на диске...**.
```cs
public static string BimCameraUnlinkRootFolder = "tbiRealViewUnlinkRootFolder";
```
Идентификатор элемента **Связать с папкой фото на диске...**.
```cs
public static string BimCameraLinkRootFolder = "tbiRealViewLinkRootFolder";
```
Идентификатор элемента **Источник виртуального начала координат**.
```cs
public static string VirtualOriginSourceMenu = "tbiVirtualOriginSourceMenu";
```
Базовый идентификатор для элемента источника виртального начала координат.
```cs
public static string SetVirtualOriginSourceBase = "tbiSetVirtualOriginSource_";
```
Идентификатор элемента **Удалить связь**.
```cs
public static string UnlinkVirtualOriginSource = "tbiUnlinkVirtualOriginSource";
```
Идентификатор элемента **Нет доступных источников виртуального начала координат**.
```cs
public static string NoAvailableVirtualOriginSources = "tbiNoVirtualOriginSources";
```

<a name="ViewerContextMenuItemIds"/>
####Идентификаторы команд контекстного меню сцены####

Идентификатор команды **Масштабировать по всем объектам**.
```cs
public static string ZoomToFitCommand = "miZoomToFitCommand";
```
Идентификатор команды **Сбросить скрытие всех объектов**.
```cs
public static string ResetHiddenNodesCommand = "miResetHiddenNodesCommand";
```
Идентификатор команды **Построить отчёт по выбранным объектам**.
```cs
public static string BuildReportBaseCommand = "miBuildReportCommand";
```
Идентификатор команды **Масштабировать по выбранным объектам**.
```cs
public static string ZoomToFitSelectedCommand = "miZoomToFitSelectedCommand";
```
Идентификатор команды **Скрыть выбранное**.
```cs
public static string HideSelectedNodesCommand = "miHideSelectedNodesCommand";
```
Идентификатор команды **Скрыть все кроме выбранного**.
```cs
public static string HideAllButSelectedNodeCommand = "miHideAllButSelectedNodeCommand";
```
Идентификатор команды **Копировать ссылку**.
```cs
public static string CopyLinkCommand = "miCopyLinkCommand";
```
Идентификатор команды **Инвертировать выбранную секущую плоскость**.
```cs
public static string InvertSelectedClipPlaneCommand = "miInvertSelectedClipPlaneCommand";
```
Идентификатор команды **Показать в журнале проблем**.
```cs
public static string ShowIssueItemCommandBase = "miShowIssueItemCommandBase";
```
Идентификатор команд перехода к определнному пересечеию в журнале проблем.
```cs
public static string SubShowIssueItemCommand = "misubShowIssueItemCommand";
```

<a name="TreeContextMenuItemIds"/>
####Идентификаторы команд контекстного меню дерева####

Идентификатор команды **Масштабировать по всем объектам**.
```cs
public static string ZoomToFitCommand = "miZoomToFitCommand";
```
Идентификатор команды **Масштабировать по выбранным объектам**.
```cs
public static string ZoomToFitSelectedCommand = "miZoomToFitSelectedCommand";
```
Идентификатор команды **Скрыть выбранное**.
```cs
public static string HideSelectedNodesCommand = "miHideSelectedNodesCommand";
```
Идентификатор команды **Сбросить скрытие всех объектов**.
```cs
public static string ResetHiddenNodesCommand = "miResetHiddenNodesCommand";
```
Идентификатор команды **Копировать ссылку**.
```cs
public static string CopyLinkCommand = "miCopyLinkCommand";
```
Идентификатор команды **Перейти к исходному файлу на диске**.
```cs
public static string OpenSourceFileLocationCommand = "miOpenSourceFileLocationCommand";
```
Идентификатор команды **Построить отчёт по выбранным объектам**.
```cs
public static string BuildReportBaseCommand = "miBuildReportCommand";
```
Идентификатор команды **Полное перестроение**.
```cs
public static string RebuildModelPartCommand = "miRebuildModelPartCommand";
```
Идентификатор команды **Выгрузить часть модели**.
```cs
public static string UnloadSelectedNodesCommand = "miUnloadSelectedNodesCommand";
```
Идентификатор команды **Скрыть все кроме выбранного**.
```cs
public static string IsolateSelectedCommand = "miIsolateSelectedCommand";
```
Идентификатор команды **Показать выбранное**.
```cs
public static string ShowSelectedNodesCommand = "miShowSelectedNodesCommand";
```
Идентификатор команды **Загрузить часть модели**.
```cs
public static string LoadSelectedNodesCommand = "miLoadSelectedNodesCommand";
```

<a name="SidebarTabIds"/>
####Идентификаторы вкладок боковой панели####

Идентификатор вкладки **Замечания**.
```cs
public static string RemarksTab = "remarksTab";
```
Идентификатор вкладки **Чаты**.
```cs
public static string ModelChatTab = "modelChatTab";
```
Идентификатор вкладки **Точки взгляда**.
```cs
public static string ViewPointsTab = "viewPointsTab";
```
Идентификатор вкладки **Проверки модели**.
```cs
public static string CollisionsDetectorTab = "collisionsDetectorTab";
```
Идентификатор вкладки **Фото Pilot-BIM Camera**.
```cs
public static string BimCameraTab = "bimCameraTab";
```