/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using Ascon.Pilot.SDK.Menu;
using System;
using System.Collections.Generic;
using System.ComponentModel.Composition;
using System.Linq;

namespace Ascon.Pilot.SDK.CustomNotificationsSample
{
    [Export(typeof(IMenu<MainViewContext>))]
    public class MainMenuPlugin : IMenu<MainViewContext>
    {
        private const string SERVICE_MY_MENU = "SayHello";
        private readonly IObjectsRepository _repository;

        [ImportingConstructor]
        public MainMenuPlugin(IObjectsRepository repository)
        {
            _repository = repository;
        }

        public void Build(IMenuBuilder builder, MainViewContext context)
        {
            var menuItem = builder.ItemNames.First();
            builder.GetItem(menuItem).AddItem(SERVICE_MY_MENU, 0).WithHeader("Say hello");
        }

        public void OnMenuItemClick(string name, MainViewContext context)
        {
            if (name == SERVICE_MY_MENU)
            {
                var messengerApi = _repository.CreateCustomNotificationProxy<IMessengerApi>(Const.NOTIFICATION_NAME);
                messengerApi.Message(_repository.GetCurrentPerson().ActualName, "Hello", DateTime.UtcNow);
            }
        }
    }
}
