/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Collections.Generic;
using System.ComponentModel.Composition;
using System.Linq;
using System.Runtime.InteropServices;
using System.Threading;
using System.Windows.Interop;
using Ascon.Pilot.SDK.Menu;
using Clipboard = System.Windows.Clipboard;

namespace Ascon.Pilot.SDK.StorageSample
{
    [Export(typeof(IMenu<StorageContext>))]
    public class StorageMenuSample : IMenu<StorageContext>
    {
        private const string COMMAND_COPY_PATH = "CopyPathCommand";
        private const string COMMAND_SHOW_WINFORM_DIALOG = "ShowDialogCommand";
        private const string COMMAND_SHOW_WPF_WINDOW = "ShowWPFDialogCommand";
        private string _path;

        [DllImport("user32.dll")]
        public static extern IntPtr GetForegroundWindow();

        public void Build(IMenuBuilder builder, StorageContext context)
        {
            var itemNames = builder.ItemNames.ToList();
            const string indexItemName = "mniShowProjectsExplorerCommand";
            var insertIndex = itemNames.IndexOf(indexItemName) + 1;

            builder.AddItem(COMMAND_COPY_PATH, insertIndex).WithHeader("Copy full path");
            var item = context.SelectedObjects.FirstOrDefault();
            if (item == null)
                return;
            _path = item.Path;

            builder.AddItem(COMMAND_SHOW_WINFORM_DIALOG, ++insertIndex).WithHeader("Show WinForms dialog");
            builder.AddItem(COMMAND_SHOW_WPF_WINDOW, ++insertIndex).WithHeader("Show WPF dialog");
        }

        public void OnMenuItemClick(string name, StorageContext context)
        {
            if (name.Equals(COMMAND_COPY_PATH, StringComparison.InvariantCultureIgnoreCase))
            {
                Clipboard.SetText(_path);
            }

            if (name.Equals(COMMAND_SHOW_WINFORM_DIALOG, StringComparison.InvariantCultureIgnoreCase))
            {
                ShowWinForm();
            }

            if (name.Equals(COMMAND_SHOW_WPF_WINDOW, StringComparison.InvariantCultureIgnoreCase))
            {
                ShowWpfDialog();
            }
        }

        private void ShowWinForm()
        {
            var activeWindowHandle = GetForegroundWindow();
            var form = new Form1();
            form.Show(new WindowWrapper(activeWindowHandle));
            
            System.Windows.Threading.Dispatcher.Run();
        }

        private void ShowWpfDialog()
        {
            var activeWindowHandle = GetForegroundWindow();
            var tempWindow = new TempWindow();
            var wih = new WindowInteropHelper(tempWindow)
            {
                Owner = activeWindowHandle
            };
            tempWindow.Show();
            wih.Owner = IntPtr.Zero;

            System.Windows.Threading.Dispatcher.Run();
        }
    }

    public class WindowWrapper : System.Windows.Forms.IWin32Window
    {
        public WindowWrapper(IntPtr handle)
        {
            _hwnd = handle;
        }

        public IntPtr Handle
        {
            get { return _hwnd; }
        }

        private readonly IntPtr _hwnd;
    }
}
