/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Collections.ObjectModel;
using System.Linq;
using Ascon.Pilot.SDK.Controls;

namespace Ascon.Pilot.SDK.TabsExtensionSample
{
    internal class FilesListViewModel : PropertyChangedBase, IDisposable
    {
        private readonly IDataObject _sourceObject;
        private readonly DateTime? _snapshotDateTime;
        private bool _isActive;

        public FilesListViewModel(IDataObject sourceObject, DateTime? snapshotDateTime)
        {
            _sourceObject = sourceObject;
            _snapshotDateTime = snapshotDateTime;
        }

        public ObservableCollection<FileItem> Files { get; } = new ObservableCollection<FileItem>();

        public void OnIsActiveChanged(bool isActive)
        {
            if (_isActive == isActive)
                return;

            _isActive = isActive;
            if (!_isActive)
                return;

            ReLoadFilesList();
        }

        private void ReLoadFilesList()
        {
            Files.Clear();
            var files = _snapshotDateTime.HasValue
                ? _sourceObject.AllFileSnapshots().First(x => x.Created == _snapshotDateTime)?.Files
                : _sourceObject.Files;

            if(files == null)
                return;

            foreach (var sourceObjectFile in files)
            {
                Files.Add(new FileItem(sourceObjectFile.Name, sourceObjectFile.Created, sourceObjectFile.Size));
            }
        }

        public void Dispose()
        {
            Files.Clear();
        }
    }

    internal class FileItem : PropertyChangedBase
    {
        public string Name { get; }
        public DateTime Created { get; }
        public long Size { get; }

        public FileItem(string name, DateTime created, long size)
        {
            Name = name;
            Created = created;
            Size = size;
        }
    }
}
