/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using Ascon.Pilot.SDK.Controls.ObjectCardView;
using Ascon.Pilot.SDK.TaskSample.Services;
using Ascon.Pilot.SDK.TaskSample.TaskEditView.TaskObjectCard;

namespace Ascon.Pilot.SDK.TaskSample.Workflow
{
    public sealed class WorkflowTaskCardControlViewModel : TaskCardControlViewModel
    {
        public WorkflowTaskCardControlViewModel(IType type, IPilotServices pilotServices, IInvalidateData invalidateData) 
            : base(type, pilotServices, invalidateData)
        {
        }

        protected override ObjectCardViewModel CreateObjectCardViewModel(IObjectsRepository repository, IPilotDialogService pilotDialogService, IAttributeFormatParser attributeFormatParser, ITransitionManager transitionManager)
        {
            return new WorkflowTaskObjectCardViewModel(repository, pilotDialogService, attributeFormatParser, transitionManager);
        }
    }

    sealed class WorkflowTaskObjectCardViewModel : ObjectCardViewModel
    {
        public WorkflowTaskObjectCardViewModel(IObjectsRepository repository, IPilotDialogService dialogService,
            IAttributeFormatParser attributeFormatParser, ITransitionManager transitionManager)
            : base(repository, dialogService, attributeFormatParser, transitionManager)
        {
        }

        public override CardControlViewModel CreateCardControlViewModel(IAttribute attribute, IType type, object initValue, bool isEditMode, bool isReadOnlyAttribute)
        {
            switch (attribute.Type)
            {
                case AttributeType.OrgUnit:
                    if (attribute.Name == SystemTaskAttributes.EXECUTOR_POSITION)
                        return null;

                    return new OrgUnitCardControlViewModel(attribute, type, initValue, isReadOnlyAttribute, _dialogService, _repository, this, _attributeFormatParser, _transitionManager, isEditMode);

                default:
                    return new CardControlViewModel(attribute, type, initValue, isReadOnlyAttribute, _dialogService, _repository, this, _attributeFormatParser, _transitionManager, isEditMode);
            }
        }
    }
}
