/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Collections.Generic;
using System.ComponentModel.Composition;
using System.Linq;
using System.Windows;
using Ascon.Pilot.SDK.Toolbar;

namespace Ascon.Pilot.SDK.ToolbarSample
{
    [Export(typeof(IToolbar<TasksViewContext2>))]
    public class TasksToolbarSample : ToolbarItemSubmenuHandler, IToolbar<TasksViewContext2>
    {
        private readonly ObjectStateSample _objectStateSample;
        
        public TasksToolbarSample()
        {
            _objectStateSample = new ObjectStateSample {IsChecked = true};
        }

        public void Build(IToolbarBuilder builder, TasksViewContext2 context)
        {
            var count = builder.Count;
            var names = builder.ItemNames;
            if (names.Last() != "tbiSeparator")
            {
                builder.AddSeparator(count);
                count++;
            }

            builder.AddMenuButtonItem("tbsMenuButton", count)
                .WithMenu(this)
                .WithHeader("Menu button")
                .WithHint("Menu button");

            builder.AddButtonItem(ToolbarItemNames.BUTTON_NAME, ++count)
                .WithHeader("Count selected items")
                .WithIsEnabled(context.SelectedTasks.Any())
                .WithHint("Count selected items");

            var icon = IconLoader.GetIcon("icon.svg");
            builder.AddToggleButtonItem(ToolbarItemNames.TOGGLE_BUTTON_NAME, ++count)
                .WithIsChecked(_objectStateSample.IsChecked)
                .WithHeader("Toggle button")
                .WithHint("Toggle button");

            builder.AddButtonItem(ToolbarItemNames.IMAGE_BUTTON_NAME, ++count)
                .WithHeader("Image button")
                .WithShowHeader(false)
                .WithIcon(icon)
                .WithHint("Image button");
        }

        public override void OnSubmenuRequested(IToolbarBuilder builder)
        {
            builder.AddButtonItem(ToolbarItemNames.MENU_ITEM_NAME1, 0).WithHeader("Menu item 1");
            builder.AddButtonItem(ToolbarItemNames.MENU_ITEM_NAME2, 1).WithHeader("Menu item 2");
            builder.AddMenuButtonItem("tbsSubmenuButton", 2).WithMenu(new SubmenuHandler()).WithHeader("Submenu items");
        }

        public void OnToolbarItemClick(string name, TasksViewContext2 context)
        {
            if (name == ToolbarItemNames.MENU_ITEM_NAME1)
                MessageBox.Show(ToolbarItemNames.MENU_ITEM_NAME1 + " Clicked");
            if (name == ToolbarItemNames.MENU_ITEM_NAME2)
                MessageBox.Show(ToolbarItemNames.MENU_ITEM_NAME2 + " Clicked");
            if (name == ToolbarItemNames.SUBMENU_ITEM_NAME1)
                MessageBox.Show(ToolbarItemNames.SUBMENU_ITEM_NAME1 + " Clicked");
            if (name == ToolbarItemNames.BUTTON_NAME)
            {
                var selected = context.SelectedTasks.Count();
                MessageBox.Show("The number of selected elements " + selected);
            }
            if (name == ToolbarItemNames.TOGGLE_BUTTON_NAME)
            {
                _objectStateSample.IsChecked = !_objectStateSample.IsChecked;
                MessageBox.Show(ToolbarItemNames.TOGGLE_BUTTON_NAME + " Clicked, State = " + _objectStateSample.IsChecked);
            }
        }
    }

    public class SubmenuHandler : ToolbarItemSubmenuHandler
    {
        public override void OnSubmenuRequested(IToolbarBuilder builder)
        {
            builder.AddButtonItem(ToolbarItemNames.SUBMENU_ITEM_NAME1, 0).WithHeader("Submenu item");
        }
    }

    internal class ObjectStateSample
    {
        public bool IsChecked { get; set; }
    }
}
