/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml;
using System.Xml.Serialization;

namespace ChangeFilesMonitor.Tools
{
    class SettingsStore
    {
        public static WindowState GetWindowsPosition(string filename)
        {
            if (!File.Exists(filename))
                return new WindowState();

            var serializer = new XmlSerializer(typeof(WindowState));
            using (var stream = File.Open(filename, FileMode.Open))
            using (var reader = XmlReader.Create(stream))
            {
                return (WindowState)serializer.Deserialize(reader);
            }
        }

        public static void SaveWindowsPosition(string filename, WindowState position)
        {
            var dir = Path.GetDirectoryName(filename);
            if (!Directory.Exists(dir))
                Directory.CreateDirectory(dir);

            var serializer = new XmlSerializer(typeof(WindowState));
            using (TextWriter writer = new StreamWriter(filename))
            {
                serializer.Serialize(writer, position);
            }
        }
    }

    [Serializable]
    public class WindowState
    {
        public WindowState()
        {
            Top = 250;
            Left = 0;
            Width = 250;
            Height = 400;
        }

        public double Left { get; set; }
        public double Top { get; set; }

        public double Width { get; set; }
        public double Height { get; set; }
    }
}
