/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.IO;

namespace ChangeFilesMonitor.Tools
{
    public static class SpecialDirectoryProvider
    {
        private const string VENDOR_FOLDER_NAME = "Ascon";
        private const string PRODUCT_NAME = "Change Files Monitor";
        private const string SETTINGS_NAME = "Settings.xml";

        private static string LocalApplicationFolder
        {
            get
            {
                return Path.Combine(Environment.GetFolderPath(Environment.SpecialFolder.LocalApplicationData), VENDOR_FOLDER_NAME, PRODUCT_NAME);
            }
        }

        public static string SettingsFilename
        {
            get { return Path.Combine(LocalApplicationFolder, SETTINGS_NAME); }
        }
    }
}