﻿ASCON Pilot SDK Samples
=======================


Требования
----------

Для создания расширений к Pilot-ICE/ECM требуется один из следующих выпусков Visual Studio
- Visual Studio 2015 Community или старше, Express for Desktop или Express for Web
- Visual Studio 2013 Community Edition
- Visual Studio 2013 Express for Desktop или Express for Web (with Update 2 или старше)
- Visual Studio 2013 Professional или старше


Запуск примера
--------------

Чтобы запустить любой пример из SDK выполните следующие шаги:
- настройте сборку проекта в следующую папку:
`C:\Users\<current_user>\AppData\Local\ASCON\Pilot-ICE\Development ` для систем Windows 7 и старше
`C:\Documents and Settings\<current_user>\Local Settings\Application Data\ASCON\Pilot-ICE\Development` для Windows XP
> Папка Development по умолчанию не существует. Ее необходимо создать.
- на вкладке *Debug* выберите пункт *Start external program* и введите путь до установленного клиента Pilot-ICE/ECM.
- сохраните изменения и запустите проект на выполнение.



Компоненты примеров
------------------

#### Ascon.Pilot.SDK.AccessRightsSample ####
Пример демонстрирует возможность редактирования прав доступа на элементы.

#### Ascon.Pilot.SDK.AutoimportSample ####
Пример демонстрирует возможность перехвата диалога автоимпорта.

#### Ascon.Pilot.SDK.BarcodeScannerSample ####
Пример демонстрирует возможность работы системы Pilot со сканером штрих-кодов.

#### Ascon.Pilot.SDK.ContextMenuSample ####
Пример демонстрирует следующие возможности:
- встраивание расширения в контекстное меню *Обозревателя проектов*
- встраивание расширения в контекстное меню управления заданиями.

#### Ascon.Pilot.SDK.CreateObjectSample ####
Пример демонстрирует возможность создания объектов через SDK. В примере описываются следующие возможности:
- создание "умной папки"
- создание ярлыка

#### Ascon.Pilot.SDK.EventSample ####
Пример демонстрирует возможность отслеживать различные события от клиента приложения. В примере описываются следующие события:
- переход в автономный режим работы клиента;
- переход в онлайн режим работы клиента;
- открытие новой вкладки главного окна клиента;
- закрытие вкладки главного окна клиента;
- обработка события загрузки расширения;
- обработка события выгрузки расширения;

#### Ascon.Pilot.SDK.FileSnapshotSample ####
Пример демонстрирует возможность загрузки, просмотра и управления версиями объектов как на *Pilot-Storage* так и в *Обозревателя проектов*

#### Ascon.Pilot.SDK.FilesSample ####
Пример демонстрирует возможность загрузки файлов и последующей работы с ними.

#### Ascon.Pilot.SDK.GraphicLayerSample ####
Пример демонстрирует возможность наложения любого графического элемента на поверхность документа в окне предпросмотра документов и управления им.

#### Ascon.Pilot.SDK.LicenseSample ####
Пример демонстрирует возможность запроса лицензии. В случае если возвращается ошибка запроса лицензии, можно дополнительно запросить информацию, чтобы определить причину ошибки. Причинами могут быть: 
- Испорченный файл лицензии
- Просроченная лицензия
- Отсутствие в файле лицензии информации по запрашиваемому продукту
- Превышение количества подключений, определенном в файле лицензии для запрашиваемого продукта

#### Ascon.Pilot.SDK.MainMenuSample ####
Пример демонстрирует возможность встраивать ваше расширение в главное меню клиента.

#### Ascon.Pilot.SDK.ModifyObjectsSample ####
Пример демонстрирует возможность встраивать ваше расширение в контекстное меню *Обозревателя проектов* и делать не полную копию выбранного элемента.

#### Ascon.Pilot.SDK.NotificationsSample ####
Пример демонстрирует возможность расширений следить за изменениями в системе. Таких как создание или изменение элементов, создание или изменение заданий и т.п. Также в примере показана возможность обработки всплывающих уведомлений. Пример показывает MessageBox с текстом уведомления и не дает клиенту показывать обработанное уведомление в стандартном диспетчере уведомлений.

#### Ascon.Pilot.SDK.ObjectCardHandle ####
Пример демонстрирует возможность расширений следить за изменениями в диалоге создания нового элемента. Изменять содержимое карточки элемента перед его созданием.

#### Ascon.Pilot.SDK.ObjectDialogPreviewSample ####
Пример демонстрирует возможность встраивать ваше расширение в панель инструментов превью в диалоге создания нового элемента.

#### Ascon.Pilot.SDK.ObjectsSample ####
Этот пример демонстрирует возможность создания и управления вкладками главного окна приложения. Также в этом примере демонстрируются следующие возможности:
- асинхронная загрузка элементов и построение простого дерева проектов
- загрузка и построение организационной структуры предприятия
- загрузка и построение списка типов элементов
- вызов диалогового окна управления общим доступом для выбранного элемента
- вызов диалогового окна выбора пользователей
- вызов стандартного диалогового окна выбора элементов из *Обозревателя проектов*

#### Ascon.Pilot.SDK.OpenDocumentInNewTabSample ####
Пример добавляет команду "Открыть в новой вкладке" в контекстное меню обозревателя проектов, которая позволяет открывать документы в новой вкладке.

#### Ascon.Pilot.SDK.PrinterSample ####
Пример демонстрирует возможности перехвата сообщений от виртуального принтера Pilot XPS.

#### Ascon.Pilot.SDK.Relations ####
Пример демонстрирует возможности управления различными связями между элементами.

#### Ascon.Pilot.SDK.SearchSample ####
Пример демонстрирует возможности создания различных поисковых запросов. В примере продемострирован поиск файлов на Pilot-Storage.

#### Ascon.Pilot.SDK.ShowReportSample ####
Пример показывает как открыть отчёт и заполнить парметры построения отчёта выбранными объектами.

#### Ascon.Pilot.SDK.ToolbarSample ####
Пример демонстрирует возможность встраивания различных пунктов в панели инструментов (Toolbar).

#### Ascon.Pilot.SDK.StorageSample ####
Пример демонстрирует возможность встраивания своих команд в контекстное меню Pilot-Storage.

#### Ascon.Pilot.SDK.SystemTrayMenuSample ####
Пример демонстрирует возможность встраивать ваше расширение в системное меню приложения.

#### Ascon.Pilot.SDK.TabsExtensionSample ####
Пример встраивания дополнительных вкладок в панель связей и файлов выбранного элемента в Обозревателе документов. Добавляет вкладку All Files для элементов, которые могут содержать файлы, на которой перечислены все файлы (включая файлы замечаний и подписей) элемента.

#### Ascon.Pilot.SDK.TaskSample ####
Пример демонстрирует возможность создания своего диалога выдачи и редактирования заданий.

#### Ascon.Pilot.SDK.ToolbarSample ####
Пример демонстрирует возможность встраивания различных пунктов в панели инструментов (Toolbar).

#### Ascon.Pilot.SDK.WPFSample ####
Пример демонстрирует следующие возможности:
- встраивание и управление вкладками главного окна клиента
- подключение библиотеки стилей *Ascon.Pilot.Themes*. Чтобы ваше расширение полностью соответствовало стилистике клиента Pilot-ICE/ECM.

#### Ascon.Pilot.SDK.XpsViewerSample ####
Пример демонстрирует возможность добавления пунктов меню в тулбар и в контекстное меню просмотрщика документов и в контекстное меню графического элемента, а также переход с приближением (масштаб указывается параметром) к графическому элементу на открытом документе. Данный плагин добавляет 3 команды в тулбар просмотрщика. Первая команда позволяет осуществить переход и приближение к замечанию на документе. Вторая команда позволяет добавить графический элемент в виде текста с датой добавления на текущую страницу документа, третья команда осуществляет переход и приближение к элементам графического слоя документа по кругу. Для демонстрации возможности навигации (зума) к только что созданному элементу, добавленный элемент добавляется в очередь на зум, а после того как приходит нотификация добавления файла графического слоя ``NotificationKind.ObjectGraphicLayerChanged``, элемент достается из очереди и вызывается команда зума. Вызывать команду зума сразу за добавлением графического элемента нельзя, необходимо дождаться события, что элемент добавлен. Плагин встраивает в контекстное меню графического элемента команду "Редактировать графический элемент", которая позволяет в отдельном окне отредактировать XAML разметку графического элемента и сохранить. Также плагин расширяет контекстное меню просмотрщика документа командой "Создать графический элемент в точке" и позволяет создать графический элемент в любой точке на любой странице.

#### Ascon.Pilot.SDK.XpsToBitmapRendererSample ####
Пример демонстрирует возможность преобразования xps документа в картинку.

#### Ascon.Pilot.SDK.QRCodeSample ####
Пример позволяет создавать и обновлять QR-коды в виде GraphicLayerElement-тов, из контекстного меню в обозревателe документов, а также, при создании документа или его новой версии. Для работы необходимо дополнить конфигурацию типа элементом с именем "QrCode" и требуемыми атрибутами.

```xml
<Configuration>
	<QrCode Url="http://myserver"
		Scale="0.5"
		OffsetX="0"
		OffsetY="0"
		Height="400"
		Width="400"
		Angle="0"
		VerticalAligment="Top"
		HorizontalAligment="Left"
		BorderThickness="1"
		PageNumber="0"/>
</Configuration>
```

#### BatchDigitalSigner ####
Плагин может подписывать сразу несколько документов, для этого необходимо селектировать нужные документы и вызвать из контекстного меню команду "Подписать документы". Для подписания должны быть созданы запросы на подпись. 

#### SignMeAsActivity ####
Пример создания действия для автоматизации подписать мною как. Скрипт атоматизации находится в файле activity.json. 

#### SubtreeUserStateAnuller ####
Пример демонстрирует возможность редактирования и отмены изменений, сделанных пользователем.

#### CommandHandlerSample ####
Пример реализации команды в расширении. Командой могут пользоваться другие плагины.

#### CommandInvokerSample ####
Пример реализации вызова команды из другого расширения.
В данном примере демонстрируется возможность вызова команды конвертации pdf в xps. Для успешного выполнения команды требуется установленное расширение PDF2XPS с действующей лицензией.

#### Ascon.Pilot.SDK.Controls ####
Библиотека с набором различных контролов. Например карточка объекта.

#### Ascon.Pilot.SDK.Extensions ####
Библиотека позволяет работать с объектами Pilot в реактивном стиле.

#### ShowObjectsTree.Async ####
Пример реализации дерева объектов в реактивном стиле

#### ShowObjectsTree.DynamicData ####
Пример реализации дерева объектов в реактивном стиле и с помощью библиотеки DynamicData.

#### ProjectCloneWizard ####
Расширения реализующее копирование проектов по шаблону.

#### ControlsProviderSample ####
Пример реализации встраивания пользовательского интерфейса чатов в расширение.

#### Ascon.Pilot.SDK.ClearCacheSample ####
Пример использования SDK для очистки кэша модуля расширения

#### Ascon.Pilot.SDK.ClearCacheDaemon ####
Пример использования SDK для очистки кэша по таймеру

#### CustomXpsAnnotations ####
Пример демонcтрирует создание и изменение пользовательских замечаний у XPS-документа

#### ShortcutRemover ####
Пример добавляет функционал удаления ярлыков на элементы при удалении самого элемента.

#### MessagesSample ####
Пример загружает все текстовые сообщения по элементу. Позволяет создать свое сообщение и чат.

#### AnnotationPageChanger ####
Пример позволяет переносить замечание на другую страницу документа.

#### DocumentsExplorerDetailsViewSample ####
Пример демонстрирует возможность замены стандартной карточки элемента в Обозревателе проектов.

#### PdfStamper ####
Пример демонстрирует возможность наложения штампов на pdf-документы.

#### CryptoProvider.CryptoAPI ####
Пример реализации плагина подписания документов. Пример интегрируется с установленными криптопровайдерами через CryptoAPI.

#### Ascon.Pilot.SDK.CryptoProviderSample ####
Пример плагина, который создаёт простую подпись (не CAdES) для документа -- считает хеш MD5 документа и сохраняет его в файл.

#### Ascon.Pilot.SDK.ChatsSample ####
Пример плагина, который отображает сообщения в чатах пользователя, при этом осуществляется подписка на создание новых чатов и изменение в них сообщений (пришло новое сообщение/старое сообщение изменено).

#### Ascon.Pilot.SDK.FileAttachmentTracking ####
Пример демонстрирует использование интерфейса `IDocumentFileHandler` для отслеживания прикрепления файлов к объектам в карточке создания или редактирования объектов. Расширение перехватывает события добавления файлов через диалог "Открыть файл" и ведет журнал прикрепленных файлов с детальной информацией: время добавления, имя файла, расширение файла, размер файла, тип объекта, ID объекта, путь к файлу и последнее изменение файла

#### HTMLRenderer ####

Пример демонстрирует создание PDF-докумена из текста электронных писем при автоимпорте файлов .eml и .MSG .

#### Ascon.Pilot.SDK.CalendarSample ####
Пример демонстирует использование интерфейса `IWorkingCalendarService` календаря рабочих дней. 