/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System.IO;

namespace Pilot.Xps.Domain.IO
{
    class IoUtils
    {
        public static Stream CreateMemoryStream(Stream source)
        {
            source.Position = 0;
            var dest = new MemoryStream((int)source.Length);
            source.CopyTo(dest);
            dest.Position = 0;
            source.Position = 0;
            return dest;
        }

        public static void CopyStream(Stream source, Stream dest)
        {
            source.Position = 0;
            dest.SetLength(0);
            source.CopyTo(dest);
            source.Position = 0;
            dest.Position = 0;
        }
    }
}
