/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Collections.Generic;
using System.IO.Packaging;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Pilot.Xps.Domain.Tools
{
    sealed class PackageReference : IDisposable
    {
        private readonly Uri _uri;

        public PackageReference(Package package, Uri uri)
        {
            _uri = uri;
            PackageStore.AddPackage(uri, package);
        }

        ~PackageReference()
        {
            ReleasePackage();
        }

        public void Dispose()
        {
            ReleasePackage();
            GC.SuppressFinalize(this);
        }

        private void ReleasePackage()
        {
            PackageStore.RemovePackage(_uri);
        }
    }
}
