/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
namespace Pilot.Xps.Domain
{
    public class XpsConstants
    {
        public virtual string XpsXmlns
        {
            get { return XPS_XMLN; }
        }

        public virtual string TypeFixedPresentation
        {
            get { return "http://schemas.microsoft.com/xps/2005/06/fixedrepresentation"; }
        }

        public virtual string TypeSignatureDefinitions
        {
            get { return "http://schemas.microsoft.com/xps/2005/06/signature-definitions"; }
        }

        public const string TYPE_RELATIONSHIP_ORIGIN = "http://schemas.openxmlformats.org/package/2006/relationships";
        public const string TYPE_DIGITAL_SIGNATURE_ORIGIN = "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin";
        public const string TYPE_DIGITAL_SIGNATURE = "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/signature";
        public const string TYPE_CERTIFICATE = "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/certificate";

        public const string TAG_DOCUMENT_REFERENCE = "DocumentReference";
        public const string TAG_SIGNATURE_DEFINITION = "SignatureDefinition";
        public const string SOURCE_ATTRIBUTE_NAME = "Source";
        public const string SPOT_ID_ATTRIBUTE_NAME = "SpotID";
        public const string SIGNATURE_PART_EXTENSION = ".psdsxs";
        public const string CERTIFICATE_PART_EXTENSION = ".cer";
        public const string SIGNATURE_ORIGIN_URI_STRING = "/package/services/digital-signature/origin.psdsor";

        public const string SIGNATURE_ORIGIN_CONTENT_TYPE = "application/vnd.openxmlformats-package.digital-signature-origin";

        public const string RELATIONSHIP_CONTENT_TYPE = "application/vnd.openxmlformats-package.relationships+xml";
        public const string FIXED_DOCUMENT_SEQUENCE_CONTENT_TYPE = "application/vnd.ms-package.xps-fixeddocumentsequence+xml";
        public const string FIXED_PAGE_CONTENT_TYPE = "application/vnd.ms-package.xps-fixedpage+xml";
        public const string DOCUMENT_STRUCTURE_CONTENT_TYPE = "application/vnd.ms-package.xps-documentstructure+xml";
        public const string FIXED_DOC_CONTENT_TYPE = "application/vnd.ms-package.xps-fixeddocument+xml";
        public const string RESOURCE_DIC_TYPE = "application/vnd.ms-package.xps-resourcedictionary+xml";
        public const string REQUIRED_RESOURCE = "http://schemas.microsoft.com/xps/2005/06/required-resource";
        public const string DOCUMENT_STRUCTURE_TYPE = "http://schemas.microsoft.com/xps/2005/06/documentstructure";
        public const string OBFUSCATED_OPENTYPE = "application/vnd.ms-package.obfuscated-opentype";

        public const string THUMBNAIL_RELSTYP = "http://schemas.openxmlformats.org/package/2006/relationships/metadata/thumbnail";
        public const string FIXEDPRESENTATION_RELSTYP = "http://schemas.microsoft.com/xps/2005/06/fixedrepresentation";

        public const string TEXT_LABELS_RELS_TYPE = @"urn:uuid:C955F1AE-C128-444C-BC17-460757C302C9";
        public const string TEXT_LABELS_DATA_FILE = @"/TextLabels.xml";
        public const string TEXT_LABELS_CONTENT_TYPE = @"application/x-ascon.textlabels+xml";

        public const string GRAPHIC_LAYER_ELEMENT_RELS_TYPE = @"urn:uuid:A7CF14F5-317C-4AFF-888B-86B2EC3B1890";
        public const string GRAPHIC_LAYER_ELEMENT_DATA_FILE = @"/graphicLayerElement.xml";
        public const string GRAPHIC_LAYER_ELEMENT_CONTENT_TYPE = @"application/x-ascon.graphicLayerElement+xml";

        public const string GRAPHIC_LAYER_IMAGE_RELS_TYPE = @"urn:uuid:{0}";
        public const string GRAPHIC_LAYER_IMAGE_DATA_FILE = @"/GraphicLayer/{0}.image";
        public const string GRAPHIC_LAYER_IMAGE_CONTENT_TYPE = @"application/x-ascon.{0}+image";

        public const string GRAPHIC_LAYER_XAML_RELS_TYPE = @"urn:uuid:{0}";
        public const string GRAPHIC_LAYER_XAML_DATA_FILE = @"/GraphicLayer/{0}.xaml";
        public const string GRAPHIC_LAYER_XAML_CONTENT_TYPE = @"application/x-ascon.{0}+xaml";

        public const string BARCODE_RELS_TYPE = @"urn:uuid:710D8FDD-942A-422F-8C5F-BC5D614AE45B";
        public const string BARCODE_DATA_FILE = @"/Barcode.xml";
        public const string BARCODE_CONTENT_TYPE = @"application/x-ascon.barcode+xml";

        public const string FIXED_DOC_INFO_RELS_TYPE = @"urn:uuid:1072E7F5-48DB-4E7E-9094-3EA79F8297C7";
        public const string FIXED_DOC_INFO_DATA_FILE = @"/FixedDocInfo.xml";
        public const string FIXED_DOC_INFO_CONTENT_TYPE = @"application/x-ascon.fixeddocinfo+xml";

        public const string ANNOTATION_MESSAGES_RELS_TYPE = @"urn:uuid:46AD7525-2E6C-4172-99CA-D2CC7F387BCD";
        public const string ANNOTATION_MESSAGES_DATA_FILE = @"/AnnotationMessages.xml";
        public const string ANNOTATION_MESSAGES_CONTENT_TYPE = @"application/x-ascon.annotationmessages+xml";

        public const string RESOURCEDICTIONARY_KEY = "http://schemas.microsoft.com/xps/2005/06/resourcedictionary-key";

        public const string XPS_XMLN = "http://schemas.microsoft.com/xps/2005/06";
        public const string OPEN_XPS_XMLN = "http://schemas.openxps.org/oxps/v1.0";

        public const string FIXED_PAGE = "FixedPage";
        public const string GLYPH = "Glyph";
        public const string PATH = "Path";
        public const string VISUAL_BRUSH = "VisualBrush";
        public const string NUMERATION_ITEM = "numeration_item";
        public const string MICROMARK_ITEM = "micromark_item";

        public const string XAML = "xaml";
        public const string BITMAP = "bitmap";
    }
}
