/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using Ascon.Pilot.DataClasses;
using Ascon.Pilot.Server.Api.Contracts;
using Ascon.Pilot.Transport;

namespace Pilot.Xps.Connection.Client
{
    interface ICallbackListener
    {
        void UpdateCommandResult(Guid requestId, byte[] data, ServerCommandResult result);
    }

    class ServerCallback : IServerCallback
    {
        private ICallbackListener _listener;

        public ServerCallback()
        {
            
        }

        public void SetCallback(ICallbackListener listener)
        {
            _listener = listener;
        }

        public void NotifyChangeset(DChangeset changeset)
        {
        }

        public void NotifyOrganisationUnitChangeset(OrganisationUnitChangeset changeset)
        {
        }

        public void NotifyPersonChangeset(PersonChangeset changeset)
        {
        }

        public void NotifyDMetadataChangeset(DMetadataChangeset changeset)
        {
        }

        public void NotifySearchResult(DSearchResult searchResult)
        {
        }

        public void NotifyGeometrySearchResult(DGeometrySearchResult searchResult)
        {
        }

        public void NotifyDNotificationChangeset(DNotificationChangeset changeset)
        {
        }

        public void NotifyCommandResult(Guid requestId, byte[] data, ServerCommandResult result)
        {
            _listener?.UpdateCommandResult(requestId, data, result);
        }

        public void NotifyChangeAsyncCompleted(DChangeset changeset)
        {
        }

        public void NotifyChangeAsyncError(Guid identity, ProtoExceptionInfo exception)
        {
        }

        public void NotifyCustomNotification(string name, byte[] data)
        {

        }
    }
}
