/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System.Collections.Generic;
using System.Security.Cryptography.X509Certificates;
using Ascon.Pilot.Common.Connection;

namespace Pilot.Xps.Connection
{
    public interface IAppSettings
    {
        IConnectionSettings ConnectionSettings { get; }
        ISigningSettings SigningSettings { get; }
    }

    public interface IConnectionSettings
    {
        int LicenseCode { get; }
        ConnectionParams ConnectionParams { get; set; }
    }

    public interface ISigningSettings
    {
        Dictionary<string, string> CertificatesMap { get; set; }
        StoreLocation StoreLocation { get; set; }
    }
}
