/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using Ascon.Pilot.DataClasses;
using Pilot.Xps.Connection.Server;

namespace Pilot.Xps.Service
{
    class XpsServiceContextLogger
    {
        private readonly XpsServiceContext _xpsServiceContext;

        public XpsServiceContextLogger(XpsServiceContext xpsServiceContext)
        {
            _xpsServiceContext = xpsServiceContext;
        }

        public bool Start()
        {
            try
            {
                _xpsServiceContext.Start();
                return true;
            }
            catch (Exception e)
            {
                if (e is PilotServerException)
                {
                    System.Console.WriteLine(e.Message);
                    return false;
                }

                System.Console.WriteLine(e);
                return false;
            }
        }

        public bool Stop()
        {
            try
            {
                _xpsServiceContext.Stop();
                return true;
            }
            catch (Exception e)
            {
                if (e is PilotServerException)
                {
                    System.Console.WriteLine(e.Message);
                    return false;
                }
                System.Console.WriteLine(e);
                return false;
            }
        }
    }
}
