# Описание

**PilotShare** или **Сервер публичных ссылок** - сервер внешних ссылок, позволяющий делиться файлами из **Pilot-Storage** и **обозревателя документов**
с пользователями, не имеющими доступа к клиенту Pilot. Скачивание файлов происходит из браузера.

# Инструкция

## 1. УСТАНОВКА

## 1.1 Установка серверной части

### 1.1.1 Установка на Linux

Серверная часть для Linux публикуется в папку `PilotShare\Bin\Release\PilotShare.Server\net5.0\linux-x64`. **PilotShare.Server** должен иметь доступ
к **Pilot-Server**, при этом не обязательно, чтобы они были расположены на одном и том же компьютере. **Сервер публичных
ссылок** требует установки и настройки.

- Скопировать собранные файлы в папку, откуда впоследствии будет работать служба.

    ```shell
    mkdir /opt/pilot-share-server
    ```

    ```shell
    cp -r /path/to/linux-64/ /opt/pilot-share-server/
    ```

- Задайте права на запуск для сервера

    ```shell
    cd /opt/pilot-share-server
    ```

    ```shell
    chmod +x PilotShare.Server
    ```


### 1.1.2 Настройка службы Linux

Для настройки автозапуска необходимо использовать настройку служб инициализации `systemd` или `supervisor`.
Из соображений безопасности рассмотренные сервисы целесообразно запускать и останавливать от имени специально
созданного пользователя, например: `pilotshareuser`.

Для этого:

- Создайте учетную запись `pilotshareuser`, от которой будет запускаться и работать **PilotShare-Server**:

    ```shell
    adduser pilotshareuser --no-create-home
    ```

- Назначьте пользователя `pilotshareuser` владельцем каталога и файлов **/opt/pilot-share-server**:

     ```shell
    chown pilotshareuser -Rv /opt/pilot-share-server
    ```

##### Настройка автозапуска с помощь "systemd"

Один из способов настройки автозапуска реализуется через подсистему инициализации **GNU/Linux systemd**.

Для того, чтобы автоматически запускать **Pilot-Share-Server** подключите следующий юнит в `systemd`:

Юнит автозапуска `pilot-share-server.service`:

```ini
[Unit]
Description=Pilot-Share-Server

[Service]
User=pilotshareuser
Group=pilotshareuser
WorkingDirectory=/opt/pilot-share-server
Restart=always
RestartSec=10
SyslogIdentifier=dotnet-pilot-share-server
Enviroment=ASPNETCORE_ENVIROMENT=Production

[Install]
WantedBy=multi-user.target
```

После создания нового юнита его необходимо включить. Для этого:

- Включите автозапуск сервиса `pilot-share-server.service`:

    ```shell
    systemctl enable pilot-share-server.service
    ```

- Перезагрузите демон:

    ```shell
    systemctl daemon-reload
    ```

- Запустите Pilot-Share-Server:

    ```shell
    systemctl start pilot-share-server
    ```

### 1.1.3 Настройка Nginx (Linux)

Для корректной работы **PilotShare-Server**, мы рекомендуем использовать прокси-сервер для обработки
входящих соединений. Например: `Apache` или `Nginx`. Инструкцию по установке и настройке вы можете найти в
соответствующем разделе выбранного вами прокси-сервера.

Пример настройки для `Nginx`:

```nginx
server {
  listen 80;
  listen [::]:80;

  access_log /var/log/nginx/reverse-access.log;
  error_log /var/log/nginx/reverse-error.log;
  
  location / {
    proxy_pass http://127.0.0.1:5000;
  }
}
```

### 1.1.4 Установка на Windows

**PilotShare-Server** на `Windows` можно запустить как web-приложение в службе `IIS (Internet Information Services)`.

Для того, чтобы запустить **PIlotShare-Server** в службе `IIS` необходимо:

- Включить Службы `IIS` в компонентах `Windows`.
- Установить `ASP.NET Core Runtime 5.0.8` (<https://dotnet.microsoft.com/download/dotnet/5.0>), если еще не установлен
- Скопировать из папки `PilotShare\Bin\Release\PilotShare.Server\net5.0\win-x64` в папку для web-сайтов `IIS` (например `C:\wwwroot\PilotShare-Server`)
- Добавить сайт в `IIS`. Для этого в Диспетчере служб `IIS` вызовите из контекстного меню узла `Сайты->Добавить веб-сайт`.
  В диалоговом окне задайте параметры нового сайта:
  - задайте имя для сайта, наприм: **PilotShareServer**
  - укажите физический путь до папки, в которую были скопированы файлы **PilotShareServer**
  - задайте тип привязки: `http`, `IP-адрес`, `порт`.

### 1.2 Настройка серверной части

Откройте в текстовом редакторе файл `appSettings.json` и задайте следующие параметры:

```json
{
  "Kestrel": {
    "EndPoints": {
      "Http": {
        "Url": "http://0.0.0.0:5000"
      }
    }
  },

  "AuthSettings": {
    "Url": "http://localhost:5545/database",
    "LicenseCode": 103,
    "Login": "sedov",
    "Password": "123456"
  }
}
```

##### Секция `Kestrel` (только для `Linux`)

  Здесь можно задать порты, для работы сервера. Например:

  ```json
    "Http": {
          "Url": "http://0.0.0.0:5020"
    },
  ```

  С такими настройками сервер будет слушать порт `5020` для `http трафика`.

##### Секция `AuthSettings`

  В этой секции нужно задать настройки подключения к **Pilot-Server**.

- `Url` - адрес подключения к **Pilot-Server** с указанием базы данных
- `LicenseCode` - номер лицензии
- `Login` - имя пользователя для подключения
- `Password` - Пароль

### 1.3 Настройки логирования

Для того, чтобы настроить логирование необходимо указать путь куда будет писаться лог. По умолчанию файлы
с логами будут лежать рядом с клиентом в папке `logs`.
Для того, чтобы задать расположения файла для логов откройте файл `log4net.config`. И измените путь для файла
в строке: `<conversionPattern value="logs/pilot_share_server.log" />` на нужный:

```xml
<appender name="FileAppender" type="log4net.Appender.RollingFileAppender">
  <file type="log4net.Util.PatternString">
    <conversionPattern value="logs/pilot_share_server.log" />
  </file>
      ...
</appender>
```

(**LINUX**) При изменении пути до папки файлов с логами не забудьте установить права для `pilotshareuser` на **запись** для этой папки.

(**WINDOWS**) При изменении пути до папки файлов с логами не забудьте установить права для `IIS` на **запись** для этой папки.

### 1.4 Установка и настройка клиентского модуля расширения

Клиентская часть собирается в папку `Bin\$(Configuration)\PilotShare.Client`. В эту папку собирается **zip архив**
модуля расширения `PilotShare.Client.zip`.

Для работы модуля необходимо:

- Импортировать конфигурацию `pillotshare.pilotcfx` в базу данных, которая будет использовать сервер внешних ссылок.
- В менеджере модулей расширения `Pilot-ICE` (`СЕРВИС`->`Настройки`->`Модули расширения`) установить плагин `PilotShare.Client.zip`.
- В диалоге "`СЕРВИС`->`Настройки`->`Управление общими настройками`" добавить конфигурацию `"Внешний адрес сервера публичных ссылок"`.

    Заполните настройки:
  - `Организационная единица` - выбрать всё предприятие;
  - `Значение` - адрес сервера внешних ссылок, например, `http://localhost:5000`.

<br />

## 2. ИСПОЛЬЗОВАНИЕ

Используйте команду контекстного меню или тулбара `"Поделиться ссылкой"` в **обозревателе документов** или в
**Pilot-Storage**. Откроется диалоговое окно , в котором можно управлять ссылками.

Менеджер ссылок имеет следующие команды:

- `Создать` - создать внешнюю ссылку
- `Редактировать` - редактировать выбранную внешнюю ссылку
- `Удалить` - удалить выбранную внешнюю ссылку

Для того, чтобы проверить работоспособность ссылки щелкните правой кнопкой мыши на ссылку из списка и выббирите команду `Открыть в браузере`
