import {describe, expect, test} from '@jest/globals';
import { mock } from 'jest-mock-extended';
import { CryptoProExtensionModel } from './cryptoProExtensionModel';
import { Queue, QueueType } from './utils/queue';
import { CryptoProAdapter } from './cryptopro/crypto-pro.adapter';
import { FileSignatureUpdater } from './file-signature.updater';
import { IAdvancementSettingsProvider } from './advancement/advancementSettingsProvider';

jest.mock('./file-signature.updater');
jest.mock('./cryptopro/crypto-pro.adapter');

describe('check can process algorithms', () => {
  
  beforeEach(() => {
  });

  test('can process only public key algorithms', () => {
    // given 
    const queue = new Queue<QueueType>();
    const adapter = mock<CryptoProAdapter>();
    const updater = mock<FileSignatureUpdater>();
    const settingsProvider = mock<IAdvancementSettingsProvider>();
    const model = new CryptoProExtensionModel(adapter, updater, queue, settingsProvider);
    
    // then
    expect(model.canProcessAlgorithms("1.2.643.7.1.1.1.1")).toBeTruthy();
    expect(model.canProcessAlgorithms("1.2.643.7.1.1.1.2")).toBeTruthy();
  });
});