import { Component, Input } from '@angular/core';
import { IType } from "@pilotdev/pilot-web-sdk";

@Component({
  selector: 'app-type',
  standalone: true,
  imports: [],
  templateUrl: './type.component.html',
  styleUrl: './type.component.scss'
})
export class TypeComponent {
  @Input() type!: IType;

  get kindName(): string {
    switch(this.type.kind) {
      case 0:
        return "User";
      case 1:
        return "System";
      case 2:
        return "Service";
      default:
        return "";
    }
  }
}
