/**
 * Copyright (c) 2024 ASCON-Design Systems LLC. All rights reserved.
 * This sample is licensed under the MIT License.
 */
import {
  ApplicationRef,
  ComponentRef,
  createComponent,
  Injectable,
  NgZone,
} from '@angular/core';
import { createApplication } from '@angular/platform-browser';

import {
  IDisposable,
  IOpenspaceView,
  ObjectsViewContext,
} from '@pilotdev/pilot-web-sdk';

import { AppComponent } from '../../app.component';
import { AngularTabId } from '../document.tabs';

@Injectable({ providedIn: 'root' })
export class AngularDemoPageSample
  implements IOpenspaceView<ObjectsViewContext>, IDisposable
{
  private _rootElement: HTMLElement | undefined;
  private _appRef: ApplicationRef | undefined;
  private _componentRef: ComponentRef<AppComponent> | undefined;

  getViewId(): string {
    return AngularTabId;
  }

  getView(context: ObjectsViewContext): HTMLElement | undefined {
    if (!this._rootElement) {
      this._rootElement = document.createElement('div');
    }

    if (!this._appRef) {
      createApplication({
        providers: [],
      }).then((appRef: ApplicationRef) => {
        this._appRef = appRef;

        const zone = appRef.injector.get(NgZone);
        zone.run(() => {
          this._componentRef = createComponent(AppComponent, {
            environmentInjector: appRef.injector,
            hostElement: this._rootElement,
          });

          appRef.attachView(this._componentRef.hostView);
        });
      });
    }

    return this._rootElement;
  }

  dispose(): void {
    if (this._componentRef) {
      this._componentRef.destroy();
      this._componentRef = undefined;
    }

    if (this._appRef) {
      this._appRef.destroy();
      this._appRef = undefined;
    }

    if (this._rootElement) {
      this._rootElement = undefined;
    }
  }
}
