/// <reference types="@pilotdev/pilot-web-2d" />
import { Observable, Subject } from 'rxjs'

export class ClickNotifier{

  private _onClicked = new Subject<ClickEvent>();

  get onClicked(): Observable<ClickEvent> {
    return this._onClicked.asObservable();
  }

  notify(page: number, point: PilotWeb2D.Point2): void {
    this._onClicked.next(new ClickEvent(page, point));
  }
}

export class ClickEvent {

  constructor(private _page: number,
              private _point: PilotWeb2D.Point2) {
  }

  public get page(): number {
    return this._page;
  }

  public get point(): PilotWeb2D.Point2 {
    return this._point;
  }
}

declare global {
  interface Window {
    clickNotifier: ClickNotifier;
  }
}

