const ModuleFederationPlugin = require('webpack/lib/container/ModuleFederationPlugin');
module.exports = {
  output: {
    publicPath: 'auto',
    uniqueName: 'bim_panel_sample',
    scriptType: 'text/javascript',
  },
  optimization: {
    // fix a temporary bug
    runtimeChunk: false
  },
  plugins: [
    new ModuleFederationPlugin({
      name: 'bim_panel_sample',
      library: { type: 'var', name: 'bim_panel_sample' },
      filename: '[name].js',
      exposes: [
        {
          'ITabs<BimElementPanelContext>':
            './src/app/extension/bim-panel-sample.ts',
        },
        {
          'IOpenspaceView<BimElementPanelContext>':
            './src/app/extension/bim-panel-sample.ts',
        },
        {
          'ITabs<BimRightPanelContext>':
            './src/app/extension/bim-panel-sample.ts',
        },
        {
          'IOpenspaceView<BimRightPanelContext>':
            './src/app/extension/bim-panel-sample.ts',
        },
      ],
      shared: {
        '@angular/core': {
          singleton: true,
        },
        '@angular/common': {
          singleton: true,
        },
        '@angular/material': {
          singleton: true,
        },
        '@angular/forms': {
          singleton: true,
        },
        '@angular/router': {
          singleton: true,
        },
        'rxjs': {
          singleton: true,
        },
        '@pilotdev/pilot-web-sdk': {
          singleton: true,
        }
      }
    })
  ]
};