import { IMenu, IMenuBuilder, ObjectsViewContext, IInitializable, InjectionSource, IDisposable } from "@pilotdev/pilot-web-sdk";

import { takeUntil, ReplaySubject } from "rxjs";

import { SETTING_NAME } from "./const";
import { SetOptionValueCommand } from "./commands/setOptionValueCommand";
import { GetSettingValueCommand } from "./commands/getOptionValueCommand";

export class SettingsSupportSample extends IMenu<ObjectsViewContext> implements IInitializable, IDisposable {
  private _destroy$ = new ReplaySubject<void>(1);
  
  private _setOptionValueCommand!: SetOptionValueCommand;
  private _getOptionValueCommand!: GetSettingValueCommand;
  
  private _settingValue?: string;

  initialize(injectionSource: InjectionSource): void {
    injectionSource.personalSettings
      .subscribePersonalSettingValueChange(SETTING_NAME)
      .pipe(takeUntil(this._destroy$))
      .subscribe(value => {
        console.log("Received new setting value:", value);
        this._settingValue = value;
      });

    this._setOptionValueCommand = new SetOptionValueCommand(injectionSource.commandBuilderProvider);
    this._getOptionValueCommand = new GetSettingValueCommand(injectionSource.commandBuilderProvider);
  }

  dispose(): void {
    this._destroy$.next();
    this._destroy$.complete();
    this._settingValue = undefined;
  }

  build(builder: IMenuBuilder, context: ObjectsViewContext): void {
    if (context.selectedObjects.length != 1)
      return;

    console.log("Current setting value:", this._settingValue);
    
    builder.addItem(SetOptionValueCommand.MENU_NAME, 3).withHeader("SDK Sample: Set option command");
    builder.addItem(GetSettingValueCommand.MENU_NAME, 4).withHeader("SDK Sample: Get option command");
  }

  onMenuItemClick(name: string, context: ObjectsViewContext): void {
    if (name == SetOptionValueCommand.MENU_NAME)
      this._setOptionValueCommand.invoke();

    if (name == GetSettingValueCommand.MENU_NAME)
      this._getOptionValueCommand.invoke();
  }
}
