import { DateTime } from '../DateTime';
import { FileData } from '../../lib/models';

import styles from './FileTable.module.css';

interface FileTableProps {
  files: FileData[];
}

export const FileTable = ({ files }: FileTableProps) => {
  return (
    <table className={`${styles['table-full-collapsed']} ${styles['solid-border']}`}>
      <thead>
        <tr>
          <th rowSpan={2}>Filename</th>
          <th colSpan={3}>Date</th>
          <th rowSpan={2}>Size</th>
        </tr>
        <tr>
          <th>Created</th>
          <th>Modified</th>
          <th>Accessed</th>
        </tr>
      </thead>
      <tbody>
        {files.map(file => {
          return (
            <tr key={file.id}>
              <th>{file.name}</th>
              <td>
                <DateTime timeISO={file.created} />
              </td>
              <td>
                <DateTime timeISO={file.modified} />
              </td>
              <td>
                <DateTime timeISO={file.accessed} />
              </td>
              <td>{file.size} bytes</td>
            </tr>
          );
        })}
      </tbody>
    </table>
  );
};
