﻿using System;
using System.Collections;
using System.Text;
using System.Threading;
using System.Windows;

namespace Ascon.Pilot.Bim.SDK.RengaModuleSample
{
    internal static class UriHelper
    {
        private const string COPY_COMMAND_POSTFIX = "_Copy";
        private static string CopiedDataTypeName => "RengaObject" + COPY_COMMAND_POSTFIX;

        public static void CopyObjectUriToClipboard(Guid objectId, Uri connectionString)
        {
            var id = objectId.ToString();
            var data = new DataObject();
            data.SetData(CopiedDataTypeName, new ArrayList() { id });
            var serverUrl = GetServerUrl(connectionString);
            var link = $"{serverUrl}/url?id={id}&app=rengauri";
            FillLinks(data, link);
            SetDataObject(data);
        }

        private static void FillLinks(DataObject data, string link)
        {
            var html = MakeLink(link);
            data.SetData(DataFormats.Text, link, true);
            data.SetData(DataFormats.Html, html, true);
        }

        private static string MakeLink(string target)
        {
            const int NUMBER_LENGTH_WITH_CR = 9;
            var htmlIntro = "<html><body>\r\n<!--StartFragment-->";
            var htmlOutro = "<!--EndFragment-->\r\n</body>\r\n</html>";

            var htmlLink = $"<a href=\"{target}\">{target}</a>";

            var startHtmlIndex = 84 + 4 * NUMBER_LENGTH_WITH_CR;
            var startFragmentIndex = startHtmlIndex + htmlIntro.Length;
            var endFragmentIndex = startFragmentIndex + htmlLink.Length;
            var endHtmlIndex = endFragmentIndex + htmlOutro.Length;

            var buff = new StringBuilder();
            buff.AppendFormat("Version:0.9\r\n");
            buff.AppendFormat("StartHTML:{0:00000000}\r\n", startHtmlIndex);
            buff.AppendFormat("EndHTML:{0:00000000}\r\n", endHtmlIndex);
            buff.AppendFormat("StartFragment:{0:00000000}\r\n", startFragmentIndex);
            buff.AppendFormat("EndFragment:{0:00000000}\r\n", endFragmentIndex);
            buff.AppendFormat("SourceURL:{0}\r\n", "about:blank");
            buff.Append(htmlIntro).Append(htmlLink).Append(htmlOutro);
            return buff.ToString();
        }

        private static bool SetDataObject(object data)
        {
            try
            {
                Clipboard.SetDataObject(data);
                return true;
            }
            catch
            {
                Thread.Sleep(10);
                try
                {
                    Clipboard.SetDataObject(data);
                    return true;
                }
                catch
                {
                    return false;
                }
            }
        }

        private static string GetServerUrl(Uri connectionString)
        {
            var connectionUrl = connectionString;
            var scheme = connectionUrl.Scheme == Uri.UriSchemeHttps ? Uri.UriSchemeHttps : Uri.UriSchemeHttp;
            var uri = new UriBuilder
            {
                Host = connectionUrl.Host,
                Scheme = scheme,
                Port = connectionUrl.Port
            };
            return uri.Uri.AbsoluteUri.TrimEnd('/');
        }
    }
}
