﻿using Ascon.Pilot.SDK;
using System.Collections.Generic;

namespace BcfApiService.Loaders
{
    public class PersonLoader
    {
        private readonly IObjectsRepository _repository;

        public PersonLoader(IObjectsRepository repository)
        {
            _repository = repository;
        }

        public IPerson LoadPerson(int id)
        {
            return _repository.GetPerson(id);
        }

        public IEnumerable<IPerson> LoadPeople()
        {
            return _repository.GetPeople();
        }
    }
}
