/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Serialization;
using System.Xml;
using Ascon.Pilot.SDK;

namespace AnnotationPageChanger
{
    internal class AnnotationSerializers
    {
        public static readonly XmlSerializer AnnotationSerializer = XmlSerializer.FromTypes(new[] { typeof(List<XpsAnnotation>), typeof(XpsAnnotation) })[0];

        public static string SerializeToString(List<XpsAnnotation> annotationContainers)
        {
            XmlWriterSettings settings = new XmlWriterSettings();
            settings.Indent = false;
            settings.NewLineHandling = NewLineHandling.None;

            using (StringWriter strWriter = new StringWriter())
            using (XmlWriter xmlWriter = XmlWriter.Create(strWriter, settings))
            {
                AnnotationSerializer.Serialize(xmlWriter, annotationContainers);
                return strWriter.ToString();
            }
        }
    }

    internal class PencilDataSerializer
    {
        public static readonly XmlSerializer Serializer = XmlSerializer.FromTypes(new[] { typeof(PencilData)})[0];

        public static string SerializeToString(PencilData pencilData)
        {
            XmlWriterSettings settings = new XmlWriterSettings();
            settings.Indent = false;
            settings.NewLineHandling = NewLineHandling.None;

            using (var strWriter = new StringWriter())
            using (XmlWriter xmlWriter = XmlWriter.Create(strWriter, settings))
            {
                Serializer.Serialize(xmlWriter, pencilData);
                return strWriter.ToString();
            }
        }
    }
}
