/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;

namespace Ascon.Pilot.SDK.FileSnapshotSample
{
    class HistoryItem
    {
        public HistoryItem(IFilesSnapshot snapshot, IObjectsRepository repository)
        {
            Created = snapshot.Created.ToLocalTime();
            Reason = snapshot.Reason;
            var person = repository.GetPerson(snapshot.CreatorId);
            CreatorName = person != null ? person.ActualName : string.Empty;
            Snapshot = snapshot;
        }

        public DateTime Created { get; private set; }
        public string CreatorName { get; private set; }
        public string Reason { get; private set; }
        public IFilesSnapshot Snapshot { get; private set; }
    }
}
