/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using Ascon.Pilot.SDK.Controls;
using System.Collections.ObjectModel;

namespace Ascon.Pilot.SDK.ObjectsSample.NodeViewModel
{
    class PersonNodeViewModel : PropertyChangedBase, IOrganizationUnitViewModel, IObserver<IPerson>
    {
        private IPerson _person;
        private readonly IObjectsRepository _repository;
        private readonly bool _isVice;

        public PersonNodeViewModel(IPerson person, IObjectsRepository repository, bool isVice)
        {
            _person = person;
            _isVice = isVice;
            _repository = repository;
            Children = new ObservableCollection<IOrganizationUnitViewModel>();
            repository.SubscribePeople().Subscribe(this);
        }

        public string Title
        {
            get {
                string title = _person.DisplayName;

                title = _isVice ? "зам. " + title : title;
                title = IsInactive ? title + " (недоступен)" : title;

                return title;
            }
        }

        public bool IsInactive
        {
            get { return _person.IsInactive(); }
        }


        public ObservableCollection<IOrganizationUnitViewModel> Children { get; private set; }

        public void OnNext(IPerson value)
        {
            if (value.Id != _person.Id) 
                return;

            _person = value;

            NotifyOfPropertyChange(string.Empty);
        }

        public void OnError(Exception error)
        {
        }

        public void OnCompleted()
        {
        }
    }
}
