/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System.ComponentModel;

namespace Ascon.Pilot.SDK.XpsViewerSample
{
    public class EditDialogViewModel : INotifyPropertyChanged
    {
        public event PropertyChangedEventHandler PropertyChanged;

        public EditDialogViewModel(string text, string title)
        {
            Text = text;
            Title = title;
        }

        private string _text;
        public string Text
        {
            get { return _text; }
            set            
            {
                _text = value;
                OnPropertyChanged("Text");
            }
        }

        public string Title { get; private set; }

        protected virtual void OnPropertyChanged(string propertyName)
        {
            var handler = PropertyChanged;
            handler?.Invoke(this, new PropertyChangedEventArgs(propertyName));
        }
    }
}