﻿/*
  Copyright © 2025 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System.Reflection;

namespace PdfStamper.Resources
{
    internal class EmbeddedResources
    {
        public static byte[] GetEmbeddedImage(string image) 
        {
            using (var stream = Assembly.GetExecutingAssembly().GetManifestResourceStream($"PdfStamper.Resources.Images.{image}"))
            {
                return Tools.StreamToArray(stream);
            }
        }

        public static byte[] GetEmbeddedFont(string fontName)
        {
            using (var stream = Assembly.GetExecutingAssembly().GetManifestResourceStream($"PdfStamper.Resources.Fonts.{fontName}"))
            {
                return Tools.StreamToArray(stream);
            }
        }
    }
}
