﻿/*
  Copyright © 2025 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System.IO;
using Newtonsoft.Json;
using System.Collections.Generic;
using PdfStamper.Models;

namespace PdfStamper.Serializing
{
    public static class Serializer
    {
        private static readonly JsonSerializerSettings SerializerSettings = new JsonSerializerSettings
        {
            Converters = new List<JsonConverter> { new SettingsJsonConverter() },
            Formatting = Formatting.Indented
        };
        
        public static string SerializeToJson(StampPosition position)
        {
            return JsonConvert.SerializeObject(position, SerializerSettings);
        }

        public static StampPosition DeserializeFromStream(Stream stream)
        {
            using (var streamReader = new StreamReader(stream))
            using (var jsonReader = new JsonTextReader(streamReader))
            {
                var serializer = new JsonSerializer();
                return serializer.Deserialize<StampPosition>(jsonReader);
            }
        }

        public static Dictionary<string, List<BaseSettingModel>> DeserializeSettings(string jsonString)
        {
            return string.IsNullOrEmpty(jsonString) 
                ? new Dictionary<string, List<BaseSettingModel>>() 
                : JsonConvert.DeserializeObject<Dictionary<string, List<BaseSettingModel>>>(jsonString, SerializerSettings);
        }

        public static string SerializeSettings(Dictionary<string, List<BaseSettingModel>> stampSettings)
        {
            return JsonConvert.SerializeObject(stampSettings, SerializerSettings);
        }
    }
}