/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using Ascon.Pilot.SDK;
using Ascon.Pilot.SDK.Controls.ObjectCardView;
using ProjectCloneWizard.ObjectsTree;

namespace ProjectCloneWizard.Common
{
    class CreationInfo
    {
        public CreationInfo()
        {
            CopyAccessForObjects = false;
            CopyAccessForFiles = false;
        }
        public IDataObject Parent { get; set; }
        public IDataObject Template { get; set; }
        public bool CopyAccessForObjects { get; set; }
        public bool CopyAccessForFiles { get; set; }
        public ICollection<NodeViewModel> ObjectsNodes { get; set; }
        public ICollection<NodeViewModel> StorageNodes { get; set; }
        public Dictionary<string, DValue> Attributes { get; set; }
        public Exception Exception { get; set; }
        public Guid ObjectIdToShow { get; set; }
    }
}
