/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Collections.Generic;
using System.Security;
using Ascon.Pilot.DataClasses;
using Ascon.Pilot.Server.Api;

namespace ChangesListener
{
    class Program
    {
        static void Main(string[] args)
        {
            System.AppDomain.CurrentDomain.UnhandledException += UnhandledExceptionTrapper;
            var server = args[0];
            var login = args[1];
            var password = args[2];
            var secureString = new SecureString();

            foreach (var c in password.ToCharArray())
                secureString.AppendChar(c);

            var credentials = ConnectionCredentials.GetConnectionCredentials(server, login, secureString);
            var client = new Client();
            var rules = new List<DRule>();
            rules.Add(new DRule
            {
                Id = new Guid("{853A5C30-5B36-4076-89F5-CA4764DEEB7F}"),
                FileExtension = ".pdf",
                ChangeType = ChangeType.Create
            });

            rules.Add(new DRule
            {
                Id = new Guid("{0B0FE415-6FB3-4C5B-9301-2420477CBBFE}"),
                FileExtension = ".xps",
                ChangeType = ChangeType.Create
            });

            rules.Add(new DRule
            {
                Id = new Guid("{C3E6454C-4901-44E9-BA67-8F861A06BB30}"),
                FileExtension = ".txt",
                ChangeType = ChangeType.Update
            });

            rules.Add(new DRule
            {
                Id = new Guid("{395CE896-AC8C-4037-B99E-D759426621CF}"),
                FileExtension = ".xps",
                ChangeType = ChangeType.Delete
            });

            client.StartListen(credentials, rules);

            Console.ReadLine();
        }

        static void UnhandledExceptionTrapper(object sender, UnhandledExceptionEventArgs e)
        {
            Console.WriteLine(e.ExceptionObject.ToString());
            Console.WriteLine("Press eny key to continue");
            Console.ReadLine();
            Environment.Exit(1);
        }
    }
}
