/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.IO;
using System.IO.Packaging;

namespace Pilot.Xps.Domain.GraphicLayer
{
    class GraphicLayerXpsPackagingStrategy
    {
        private string _relsType;
        private string _dataFile;
        private string _contentType;
        private readonly Package _package;

        public GraphicLayerXpsPackagingStrategy(Package package)
        {
            _package = package;
        }

        public Stream GetPackageStream(string type, Guid contentId, bool isCreateMode)
        {
            switch (type)
            {
                case XpsConstants.BITMAP:
                    _relsType = string.Format(XpsConstants.GRAPHIC_LAYER_IMAGE_RELS_TYPE, contentId);
                    _dataFile = string.Format(XpsConstants.GRAPHIC_LAYER_IMAGE_DATA_FILE, contentId);
                    _contentType = string.Format(XpsConstants.GRAPHIC_LAYER_IMAGE_CONTENT_TYPE, contentId);
                    return XpsTools.GetStreamInPackage(_package, _relsType, _dataFile, _contentType, isCreateMode);
                case XpsConstants.XAML:
                    _relsType = string.Format(XpsConstants.GRAPHIC_LAYER_XAML_RELS_TYPE, contentId);
                    _dataFile = string.Format(XpsConstants.GRAPHIC_LAYER_XAML_DATA_FILE, contentId);
                    _contentType = string.Format(XpsConstants.GRAPHIC_LAYER_XAML_CONTENT_TYPE, contentId);
                    return XpsTools.GetStreamInPackage(_package, _relsType, _dataFile, _contentType, isCreateMode);
            }
            return null;
        }
    }
}
