/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Collections.Generic;
using System.IO;
using System.Windows;
using Pilot.Xps.Domain.Render;

namespace Pilot.Xps.Domain.Labels
{
    class BarcodeLabelsMerger
    {
        private readonly IXpsWriter _xpsWriter;
        private readonly IBarCodeCreator _barCodeCreator;

        public BarcodeLabelsMerger(IXpsWriter xpsWriter, IBarCodeCreator barCodeCreator)
        {
            _xpsWriter = xpsWriter;
            _barCodeCreator = barCodeCreator;
        }

        public Stream Merge(Stream source, string textLabelConfiguration, string barcodeConfiguration, Dictionary<string, object> values, List<string> attributeNames)
        {
            if (string.IsNullOrEmpty(textLabelConfiguration) && string.IsNullOrEmpty(barcodeConfiguration))
                return source;

            List<Tuple<string, Uri, Stream, int>> textLabels = null;
            if (!string.IsNullOrEmpty(textLabelConfiguration))
            {
                textLabels = _xpsWriter.GenerateGlyphsFromTextLabels(textLabelConfiguration, _xpsWriter.GetPagesSizes(source), values, attributeNames);
            }

            Tuple<Tuple<string, Uri, Stream, int>, HorizontalAlignment, VerticalAlignment, double> barcodeholder = null;
            if (!string.IsNullOrEmpty(barcodeConfiguration))
            {
                var barcode = XpsTools.GetBarcode(barcodeConfiguration);
                var firstPageSize = _xpsWriter.GetFirstPageSizeFromXps(source);
                var barcodeInPathes = _barCodeCreator.GetBarcodeForXps(barcode, firstPageSize);
                if (barcodeInPathes != null)
                {
                    barcodeholder = new Tuple<Tuple<string, Uri, Stream, int>, HorizontalAlignment, VerticalAlignment, double>(barcodeInPathes,
                        HorizontalAlignment.Left, VerticalAlignment.Top, barcode.Angle);
                }
            }

            return _xpsWriter.AddTextLabelsAndBarcode(source, textLabels, barcodeholder);
        }
    }
}
