/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;

namespace Pilot.Xps.Domain.Labels
{
    class TextBlockXamlHandler
    {
        private readonly RegexOptions _options = RegexOptions.Compiled | RegexOptions.Singleline;
        private readonly StringBuilder _textBlockXaml;

        public TextBlockXamlHandler(string textBlockXml)
        {
            _textBlockXaml = string.IsNullOrEmpty(textBlockXml) ? new StringBuilder("<TextBlock></TextBlock>") : new StringBuilder(textBlockXml);

            Value = CutTextBlockValue();
            var text = CutTextAttribute();

            MakeNormalTextBlock();

            if (string.IsNullOrEmpty(Value))
            {
                Value = text;
            }

            SetValue(Value);
        }

        public string Value { get; }

        public string GetNormalTextBlockXaml()
        {
            return _textBlockXaml.ToString();
        }

        private static string RemoveNewLines(string str)
        {
            return str.Trim('\r', '\n');
        }

        private void SetValue(string value)
        {
            _textBlockXaml.Replace("</TextBlock>", $"{value}</TextBlock>");
        }

        private bool IsNormalTextBlock(string xml)
        {
            var regex = new Regex("<TextBlock(.*?)>(.*?)</TextBlock>", _options);

            return regex.IsMatch(xml);
        }

        private string CutTextAttribute()
        {
            var regex = new Regex("(?<=Text=\")(.*?)(?=\")", _options);
            var textBlockXml = _textBlockXaml.ToString();

            if (regex.IsMatch(textBlockXml))
            {
                var textValue = regex.Match(textBlockXml).Value;
                _textBlockXaml.Replace($"Text=\"{textValue}\"", "");
                return textValue;
            }

            return string.Empty;
        }

        private string CutTextBlockValue()
        {
            var regex = new Regex("(<TextBlock(.*?)>)(?<value>(.*))(</TextBlock>)", _options);
            var textBlockXml = _textBlockXaml.ToString();

            if (regex.IsMatch(textBlockXml))
            {
                var value = regex.Match(textBlockXml).Groups["value"].Value;
                if (!string.IsNullOrEmpty(value))
                {
                    _textBlockXaml.Replace(value, "");
                    return RemoveNewLines(value);
                }
            }

            return string.Empty;
        }

        private void MakeNormalTextBlock()
        {
            if (!IsNormalTextBlock(_textBlockXaml.ToString()))
            {
                _textBlockXaml.Replace("/>", "></TextBlock>");
            }
        }
    }
}
