/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System.Windows.Xps.Packaging;
using Ascon.Pilot.DataClasses;

namespace Pilot.Xps.Domain.Signatures
{
    static class SignatureExtensions
    {
        public static XpsSignatureDefinition ToXpsSignatureDefinition(this INSignature signature)
        {
            return new XpsSignatureDefinition
            {
                RequestedSigner = signature.RequestedSigner,
                SpotId = signature.Id,
                Intent = signature.Role
            };
        }
    }
}
