/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Runtime.CompilerServices;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Data;
using Ascon.Pilot.Theme.Controls;

namespace PilotShare.Client.Utils
{
    public abstract class PropertyChangedBase : INotifyPropertyChanged
    {
        public event PropertyChangedEventHandler PropertyChanged;

        private bool? _closeResult;

        [EditorBrowsable(EditorBrowsableState.Never)]
        public bool? CloseResult
        {
            get { return _closeResult; }
            private set
            {
                _closeResult = value;
                NotifyOfPropertyChange(nameof(CloseResult));
            }
        }

        public void CloseView(bool dialogResult)
        {
            CloseResult = dialogResult;
        }

        protected virtual void NotifyOfAllPropertiesChanged()
        {
            NotifyOfPropertyChange(null);
        }

        protected void NotifyOfPropertyChange([CallerMemberName] string propertyName = "")
        {
            PropertyChanged?.Invoke(this, new PropertyChangedEventArgs(propertyName));
        }
    }
}
