/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Serialization;

namespace PilotShare.Core
{
    [Serializable]
    public class Item
    {
        [XmlAttribute]
        public string Name { get; set; }
        [XmlAttribute]
        public string FileId { get; set; }

        [XmlAttribute] 
        public long FileSize { get; set; } = 0;

        [XmlAttribute]
        public string Md5 { get; set; }

        public List<Item> Children { get; set; }

        public bool ShouldSerializeFileId()
        {
            return FileId != null;
        }

        public bool ShouldSerializeFileSize()
        {
            return FileSize > 0;
        }

        public bool ShouldSerializeMd5()
        {
            return !string.IsNullOrEmpty(Md5);
        }

        public bool ShouldSerializeChildren()
        {
            return Children != null;
        }
    }
}
