/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using Ascon.Pilot.ClientCore.Search;
using Ascon.Pilot.Common.DataProtection;
using Ascon.Pilot.DataClasses;
using Ascon.Pilot.Server.Api;
using QuerySearchSample;

new SearchService().StartSearch();

public class SearchService
{
    public void StartSearch()
    {
        // Connect to demo base pilot-ice_ru
        var credentials = ConnectionCredentials.GetConnectionCredentials("http://localhost:5545/pilot-ice_ru", "sedov", "123456".ConvertToSecureString());
        var client = new HttpPilotClient(credentials.GetConnectionString(), credentials.GetConnectionProxy());
        // set isCheckedClientVersion to true if you need to check if the versions of the client and server match
        client.Connect(false);
        var resultCallBack = new SearchResultCallBack(ShowResult);
        var serverApi = client.GetServerApi(resultCallBack);
        client.GetAuthenticationApi().Login(credentials.DatabaseName, credentials.Username, credentials.ProtectedPassword, false, 100);
        serverApi.OpenDatabase();
        serverApi.AddSearch(MakeSearchDefinition());
        Console.ReadKey();
    }

    private DSearchDefinition MakeSearchDefinition()
    {
        var query = QueryBuilderFactory.CreateEmptyQueryBuilder();
        query.Must(ObjectFields.Context.Be(new Guid("8f8bd68e-8c5a-4860-aa7a-78b38a31815e"))); // Основной комплект "Технологии производства"
        query.MustNot(ObjectFields.ObjectState.Be(ObjectState.Frozen));
        query.MustAnyOf(AttributeFields.Integer("sheet_number").BeInRange(1, 3));
        return new DSearchDefinition
        {
            Id = Guid.NewGuid(),
            Request =
            {
                MaxResults = 5, // Ограничение количества результатов поиска
                SearchKind = SearchKind.Custom,
                SearchString = query.ToString()
            }
        };
    }

    private void ShowResult(DSearchResult res)
    {
        // Use search result here
        if (res.Found == null) Console.WriteLine("Поиск не дал результатов");
        else
        {
            Console.WriteLine($"Результаты поиска в Основном комплекте \"Технологии производства\":\nНайдено объектов: {res.Found.Count()}.");
            Console.WriteLine($"Id's:\n{string.Join("\n", res.Found)}");
        }
    }
}