﻿using Ascon.Pilot.DataClasses;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.RazorPages;
using System.Text;
using UrlsHandlerSample.Services;

namespace UrlsHandlerSample.Pages
{
    public class ObjectInfoModel : PageModel
    {
        private readonly IPilotObjectInfoService _objectInfoService;

        public ObjectInfoModel(IPilotObjectInfoService objectInfoService)
        {
            _objectInfoService = objectInfoService;
        }

        [BindProperty]
        public DObject? Object { get; set; }

        public string GetSimpleTitle()
        {
            if (Object == null)
                return "";

            var strBuilder = new StringBuilder();
            foreach (var attr in Object.Attributes)
            {
                strBuilder.Append(attr.Value.ToString() + " ");
            }
            return strBuilder.ToString();
        }
        
        public async Task OnGet()
        {
            var paramId = Request.Query["id"].ToString();
            if (string.IsNullOrEmpty(paramId))
                return;

            var objectId = Guid.Parse(paramId);
            Object = await _objectInfoService.GetObjectInfo(objectId);
        }
    }

}
