﻿
namespace UrlsHandlerSample.Services
{
    public interface IPilotRegisterService
    {
        void RegisterHandler(string name, Uri callbackUri);
        void UnregisterHandler(string name);
        void UnregisterAll();
    }

    class PilotRegisterService : IPilotRegisterService
    {
        private readonly HashSet<string> _handlers = new HashSet<string>();
        private readonly IPilotServiceConnector _serviceConnector;
        private const string CONNECTION_ERROR_MESSAGE = "The connection to the Pilot-Server is not established. Please connect to the Pilot-Server first.";

        public PilotRegisterService(IPilotServiceConnector serviceConnector)
        {
            _serviceConnector = serviceConnector;
        }

        public void RegisterHandler(string name, Uri callbackUri)
        {
            var client = _serviceConnector.GetClient() ?? throw new Exception(CONNECTION_ERROR_MESSAGE);
            var urlHandlerApi = client.GetUrlHandlerRegistryApi();
            urlHandlerApi.RegisterHandler(name, callbackUri);
            _handlers.Add(name);
        }

        public void UnregisterAll()
        {
            var client = _serviceConnector.GetClient() ?? throw new Exception(CONNECTION_ERROR_MESSAGE);
            var urlHandlerApi = client.GetUrlHandlerRegistryApi();
            foreach (var handler in _handlers)
            {
                urlHandlerApi.UnregisterHandler(handler);                
            }
        }

        public void UnregisterHandler(string name)
        {
            var client = _serviceConnector.GetClient() ?? throw new Exception(CONNECTION_ERROR_MESSAGE);
            var urlHandlerApi = client.GetUrlHandlerRegistryApi();
            urlHandlerApi.UnregisterHandler(name);
            _handlers.Remove(name);
        }
    }
}
