/*
Copyright © 2024 ASCON-Design Systems LLC. All rights reserved.
This sample is licensed under the MIT License.
*/

import { OriginType } from "../crypto-pro.adapter";


export class CryptoProPluginInitializationError extends Error {
  constructor(message: string) {
    super(message);
    Object.setPrototypeOf(this, CryptoProPluginInitializationError.prototype);
  }
}

export const errorMessagePrefixes: Record<OriginType | "unexpected", string> = {
  initialize: "При инициализации КриптоПро ЭЦП Browser plug-in произошла ошибка:",
  sign: "",
  verify: "",
  verifyImportedSignature: "",
  getCertificates: "",
  canProcessAlgorithms: "",
  canProcessSignature: "",
  unexpected: "В процессе работы расширения произошла ошибка!"
}
