﻿/*
  Copyright © 2025 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using PdfStamper.Resources;

namespace PdfStamper.Settings;

internal class SettingsModel
{
    public string? TypeName { get; set; }
    public byte[]? Image { get; set; }
    public string? StampHeader { get; set; }
    public string? IntoProductionRole { get; set; }
    public Position Position { get; set; }
    public int OffsetX { get; set; }
    public int OffsetY { get; set; }
    public int PageNumber { get; set; }
    public bool IsOnLastPage { get; set; }
    public int OffsetPreviousX { get; set; }
    public int OffsetPreviousY { get; set; }

    public static SettingsModel GetDefault()
    {
        return new SettingsModel
        {
            TypeName = string.Empty,
            Image = EmbeddedResources.GetEmbeddedImage("logo.png")?.ToByteArray(),
            StampHeader = @"Подлинник электронного документа, подписанного ЭП, хранится в системе электронного документооборота Pilot",
            IntoProductionRole = "В производство работ",
            Position = Position.LeftBottom,
            OffsetX = 70,
            OffsetY = 125,
            IsOnLastPage = true,
            PageNumber = 1,
            OffsetPreviousX = 0,
            OffsetPreviousY = 30
        };
    }
}

internal class StampPosition 
{
    public double X { get; set; }
    public double Y { get; set; }
}

internal enum Position
{
    LeftTop = 0,
    RightTop = 1,
    LeftBottom = 2,
    RightBottom = 3
}
