import {
  IDisposable,
  IOpenspaceView,
  PageContext,
} from "@pilotdev/pilot-web-sdk";
import { createApp, type App as AppType } from "vue";

import { VuePageAddress } from "../navigation";
import App from "../../App.vue";

export class VueViewSample implements IOpenspaceView<PageContext>, IDisposable {
  private _rootElement: HTMLElement | undefined;
  private _vueApp: AppType<Element> | undefined;

  getViewId(): string {
    return VuePageAddress;
  }

  getView(): HTMLElement | undefined {
    if (!this._rootElement) {
      this._rootElement = document.createElement("div");
      this._rootElement.setAttribute("id", "app");
    }

    if (!this._vueApp) {
      this._vueApp = createApp(App);
    }

    this._vueApp.mount(this._rootElement);

    return this._rootElement;
  }

  dispose(): void {
    if (this._vueApp) {
      this._vueApp.unmount();
      this._vueApp = undefined;
    }

    if (this._rootElement) {
      this._rootElement = undefined;
    }
  }
}
