/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.IO;
using System.Windows.Media;
using SharpVectors.Converters;
using SharpVectors.Renderers.Wpf;

namespace Ascon.Pilot.SDK.Controls.Converters
{
    public class SvgConverterHelper
    {
        public static bool TryConvert(byte[] bytes, out DrawingGroup drawing)
        {
            drawing = null;
            if (bytes == null || bytes.Length == 0)
                return false;

            using (var stream = new MemoryStream(bytes))
            {
                try
                {
                    var settings = new WpfDrawingSettings
                    {
                        IncludeRuntime = true,
                        TextAsGeometry = false,
                        EnsureViewboxPosition = false
                    };

                    var converter = new FileSvgReader(settings);
                    drawing = converter.Read(stream);
                }
                catch (Exception)
                {
                    return false;
                }
            }

            return true;
        }
    }
}
