SDK для серверных модулей расширения
===============


Требования
----------

Для создания серверных модулей расширения к Pilot-Server требуется один из следующих выпусков Visual Studio
- Visual Studio 2017 Professional Edition или старше

Создание и настройка проекта расширения
---------------------------------------

Чтобы создать новое расширение для Pilot-Server выполните следующие действия:

- Создайте проект типа Class Library (.NET Standard).
- Вызовите диалог настройки проекта. В поле AssemblyName добавьте к названию сборки `.servext` Например `PilotServerExtension.servext`
- Вызовите диалог редактирования информации о сборке. (Assembly Information...) Для этого нажмите на кнопку `Assembly Information...` и заполните необходимые поля.
    > Обязательно заполните поля Title, Product и Assembly version, т.к. Pilot-Server при загрузке вашего расширения будет искать информацию именно в этих полях.
- Подключите к проекту nuget пакеты System.ComponentModel.Composition и Ascon.Pilot.ServerExtensions.SDK.

Для удобства отладки проекта серверного расширения, сборка может быть размещена в папке `[path]\Development`, где **[path]** - это путь, по которому размещен исполняемый файл Pilot-Server,
в данном случае установка серверного расширения через клиентское приложение не потребуется и расширение будет загружено при запуске Pilot-Server (папка **Development** по умолчанию отсутствует, ее необходимо создать).

Подключение SDK к проекту расширения
------------------------------------

Для подключения SDK Pilot к проекту расширения можно воспользоваться встроенным в Visual Studio механизмом распространения пакетов - NuGet Packages Manager.
Для того, чтобы подключить SDK с помощью Nuget Package Manager выполните следующие шаги:
- Вызовите [Package Manager Console](https://docs.nuget.org/docs/start-here/using-the-package-manager-console);
- Выполните команду:
```cpp
Install-Package Ascon.Pilot.ServerExtensions.SDK
```

- Щелкните правой кнопкой мыши на проекте и вызовите команду `Manage NuGet Packages`;
- Установите NuGet пакет Ascon.Pilot.ServerExtensions.SDK для вашего проекта.


## Содержание
[Система расширений](#typesOfExtensions)
- [Действие для серверных автоматизаций IServerActivity](#IServerActivity)
	- [IServerActivityContext](#IServerActivityContext)
	- [IAutomationEventContext](#IAutomationEventContext)
- [Расширение для добавления дополнительной информации к записям журнала пользовательских действий](#IUserActionAppender)
	- [IPositionChangedContext](#IPositionChangedContext)
	- [IPersonPositionChangedContext](#IPersonPositionChangedContext)
	- [IChangesetContext](#IChangesetContext)
	- [ILicenseContext](#ILicenseContext)
	- [IFileContext](#IFileContext)
	- [ISnapshotContext](#ISnapshotContext)
	- [IAuthenticationContext](#IAuthenticationContext)
	- [IMetadataContext](#IMetadataContext)
	- [IPersonChangedContext](#IPersonChangedContext)
- [API для сбора метрик Pilot-Server IMetricsEvents](#IMetricsEvents)
- [API для поиска объектов IAutomationSearchService](#IAutomationSearchService)
- [API для регистрации дополнительных контрактов клиент-серверного взаимодействия IServerApiFactory](#IServerApiFactory)


<a name="typesOfExtensions"/>
Система расширений
-------------------------

Система расширений основана на стандартном механизме расширений приложений в .NET - Managed Extensibility Framework (MEF). SDK содержит ряд экспортируемых и импортируемых интерфейсов. К экспортируемым интерфейсам относятся интерфейсы, которые описывают тип расширения. К импортируемым интерфейсам относятся интерфейсы взаимодействия с клиентом и работы с данными.

<a name="IServerActivity"/>
### Интерфейс IServerActivity ###

Данный интерфейс позволяет добавить новое действие, доступное в серверных скриптах автоматизаций.

```cpp
string IServerActivity.Name { get; };
```
Имя действия, используемое в скрипте автоматизации.

```cpp
Task IServerActivity.RunAsync(IModifierBase modifier, IModifierBackend backend, IServerActivityContext serverActivityContext, IAutomationEventContext automationEventContext);
```
Асинхронный метод обработки запуска действия.
где:
 - `modifier` - модификатор, позволяющий вносить изменения в объекты;
 - `backend` - обеспечивает доступ к данным системы;
 - `serverActivityContext` - контекст запуска действия, позволяющий получить параметры запуска действия;
 - `automationEventContext` - контекст события, позволяющий определить объект-источник события и другую дополнительную информацию.


Пример IServerActivity:
```cpp
[Export(typeof(IServerActivity))]
public class SetLastWriteTimeActivity : IServerActivity
{
	public string Name => "SetLastWriteTime";

	public Task RunAsync(IModifierBase modifier, IModifierBackend backend, IServerActivityContext serverActivityContext, IAutomationEventContext automationEventContext)
	{
		modifier.EditObject(automationEventContext.Source).SetAttribute("LastWriteTime", DateTime.UtcNow);
		return Task.CompletedTask;
	}
}
```

<a name="IServerActivityContext"/>
### Интерфейс IServerActivityContext ###

Контекст запуска действия, позволяющий получить параметры запуска действия.

```cpp
Dictionary<string, object> IServerActivityContext.Params { get; }
```
Словарь параметров запуска действия, заданных в json скрипта автоматизации.

```cpp
List<string> IServerActivityContext.SourceTypes { get; }
```
Список типов, заданных в json скрипта автоматизации, для которых должно выполняться действие.

```cpp
TargetType? IServerActivityContext.Target { get; }
```
Определяет, должно ли действие быть применено к объекту-источнику события либо к связанным с ним объектам.

```cpp
RelationType? IServerActivityContext.RelationType { get; }
```
Определяет, к каким типам связанных объектов должно применяться действие (применимо только в случае IServerActivityContext.Target==TargetType.Relations).

```cpp
RelationFilterByChangeKind? IServerActivityContext.RelationFilterByChangeKind { get; } { get; }
```
Определяет, должно ли применяться действие ко всем связанным объектам, или же только к добавленным или удаленным.

```cpp
Dictionary<string, string> IServerActivityContext.Errors { get; }
```
Список ошибок при разборе json действия.

```cpp
T GetService<T>() where T : class;
```
Получение дополнительных сервисов. В текущей версии доступно получение следующих сервисов: 

### Сервис IAutomationNotifier ###

```cpp
var notifier = serverActivityContext.GetService<IAutomationNotifier>();
```
Сервис IAutomationNotifier служит для отправки уведомлений пользователям.

```cpp
void Notify(int personId, INObject obj, string message, string notificationName);
```
где:
  - `personId` - идентификатор пользователя, которому будет отправлено уведомление;
  - `obj` - объект, по которому будет создано уведомление. При клике пользователем по всплывающему уведомлению будет осуществлен переход к данному объекту;
  - `message` - текст сообщения уведомления;
  - `notificationName` - внутреннее имя канала уведомлений. Доступно для получения на стороне клиентского SDK обработки уведомлений;

### Сервис IAutomationFileProvider ###

```cpp
var fileHandler = serverActivityContext.GetService<IAutomationFileProvider>();
```
Сервис `IAutomationFileProvider` служит для получения файлов из файлового архива.

Метод проверки существования файла в файловом архиве.
```cpp
bool Exists(Guid fileId);
```
где:
  - `fileId` - идентификатор файла; 

Асинхронный метод открытия файла на чтение.
```cpp
Task<Stream> OpenReadAsync(Guid id);
```
где:
  - `fileId` - идентификатор файла; 

<a name="IAutomationEventContext"/>
### Интерфейс IAutomationEventContext ###

Контекст события-триггера действия.

```cpp
INObject IAutomationEventContext.Source { get; }
```
Объект-источник события.

```cpp
IEnumerable<INChange> IAutomationEventContext.Changes { get; }
```
Набор изменений, в результате которого сработал триггер. Включает в себя изменение по объекту-источнику события, если он был изменен.

```cpp
INPerson IAutomationEventContext.InitiatingPerson { get; }
```
Пользователь-инициатор события.

```cpp
DateTime IAutomationEventContext.EventDate { get; }
```
Время наступления события в формате UTC.

<a name="IUserActionAppender"/>
### Интерфейс IUserActionAppender ###

Данный интерфейс позволяет добавить обработчик, добавляющий дополнительную информацию к записи журнала пользовательских действий

```cpp
string ProcessEvent(IModifierBackend backend, IBaseEventContext context);
```
Метод обработки новой записи журнала пользовательских действий
где:
  - `backend` - обеспечивает доступ к данным системы;
  - `context` - контекст, дающий информацию о записи в журнал. Ниже перечислены возможные варианты контекстов.


  <a name="IPositionChangedContext"/>
### Интерфейс IPositionChangedContext ###

Контекст записи об изменении/добавлении орагнизационной единицы

```cpp
EventKind EventKind { get; }
```
Тип события

```cpp
DateTime ServerDateTime { get; }
```
Серверная дата записи изменения

```cpp
string Login { get; }
```
Логин пользователя от имени которого произошло изменение

```cpp
string IpAddress { get; }
```
IP адрес ПК с котрого инициировалось изменение

```cpp
INOrganisationUnit IPositionChangedContext.Created { get; }
```
Созданная организационная единица

```cpp
INOrganisationUnit IPositionChangedContext.Updated { get; }
```
Измененнная организационная единица

  <a name="IPersonPositionChangedContext"/>
### Интерфейс IPersonPositionChangedContext ###
  Контекст записи об изменении назначения или снятия пользователя с должности

```cpp
EventKind EventKind { get; }
```
Тип события

```cpp
DateTime ServerDateTime { get; }
```
Серверная дата записи изменения

```cpp
string Login { get; }
```
Логин пользователя от имени которого произошло изменение

```cpp
string IpAddress { get; }
```
IP адрес ПК с котрого инициировалось изменение

```cpp
INPersonOnPositionData IPersonPositionChangedContext.INPersonOnPositionData { get; }
```
Данные об назначнии/ снятии пользователя с должности

 <a name="IChangesetContext"/>
### Интерфейс IChangesetContext ###
  Контекст записи об изменении объектов

```cpp
EventKind EventKind { get; }
```
Тип события

```cpp
DateTime ServerDateTime { get; }
```
Серверная дата записи изменения

```cpp
string Login { get; }
```
Логин пользователя от имени которого произошло изменение

```cpp
string IpAddress { get; }
```
IP адрес ПК с котрого инициировалось изменение

```cpp
Guid IChangesetContext.ObjectId { get; }
```
Идентификатор объекта

```cpp
IReadOnlyList<INChange> IChangesetContext.Changes { get; }
```
Изменения, произведенные над объектом

```cpp
string IChangesetContext.ErrorString { get; }
```
Текст ошибки, если изменение не было принято

 <a name="ILicenseContext"/>
### Интерфейс ILicenseContext ###
  Контекст записи захвата/освобождения лицензии

```cpp
EventKind EventKind { get; }
```
Тип события

```cpp
DateTime ServerDateTime { get; }
```
Серверная дата срабатывания события

```cpp
string Login { get; }
```
Логин пользователя

```cpp
string IpAddress { get; }
```
IP адрес ПК пользователя

```cpp
int LicenseType { get; }
```
Тип лицензии

```cpp
int PersonId { get; }
```
Идентификатор пользователя

 <a name="IFileContext"/>
### Интерфейс IFileContext ###
  Контекст файла

```cpp
EventKind EventKind { get; }
```
Тип события

```cpp
DateTime ServerDateTime { get; }
```
Серверная дата срабатывания события

```cpp
string Login { get; }
```
Логин пользователя

```cpp
string IpAddress { get; }
```
IP адрес ПК пользователя

```cpp
Guid ObjectId { get; }
```
Идентификатор объекта

```cpp
string ObjectTitle { get; }
```
Отображаемое наименование объекта

```cpp
int TypeId { get; }
```
Идентификатор типа

```cpp
Guid FileId { get; }
```
Идентификатор файла

```cpp
int PersonId { get; }
```
Идентификатор пользователя

 <a name="ISnapshotContext"/>
### Интерфейс ISnapshotContext ###
  Контекст версии

```cpp
EventKind EventKind { get; }
```
Тип события

```cpp
DateTime ServerDateTime { get; }
```
Серверная дата записи изменения

```cpp
string Login { get; }
```
Логин пользователя от имени которого произошло изменение

```cpp
string IpAddress { get; }
```
IP адрес ПК с котрого инициировалось изменение

```cpp
Guid ObjectId { get; }
```
Идентификатор объекта

```cpp
int DeletedSnapshotsCount { get; }
```
Количество удаленных версий

 <a name="IAuthenticationContext"/>
### Интерфейс IAuthenticationContext ###
  Контекст события аутентификации

```cpp
EventKind EventKind { get; }
```
Тип события

```cpp
DateTime ServerDateTime { get; }
```
Серверная дата события

```cpp
string Login { get; }
```
Логин пользователя

```cpp
string IpAddress { get; }
```
IP адрес ПК с котрого происходила аутентификация

```cpp
string Message { get; }
```
Сообщение обо ошибке при неудачной аутентификации

 <a name="IMetadataContext"/>
### Интерфейс IMetadataContext ###
  Контекст записи об изменении конфигурации базы данных (типы, атрибуты, состояния, автоматизации)

```cpp
EventKind EventKind { get; }
```
Тип события

```cpp
DateTime ServerDateTime { get; }
```
Серверная дата записи изменения

```cpp
string Login { get; }
```
Логин администратора от имени которого произошло изменение

```cpp
string IpAddress { get; }
```
IP адрес ПК с котрого инициировалось изменение

 <a name="IPersonChangedContext"/>
### Интерфейс IPersonChangedContext ###
  Контекст записи об изменении учетных данных пользователя (поля интерфейса `INPerson`: `Login`, `DisplayName`, `Comment`, `Sid`, `UidDn`, `Email`, `Phone`, `IsDeleted`, `IsAdmin`, `IsInactive`)

```cpp
EventKind EventKind { get; }
```
Тип события

```cpp
DateTime ServerDateTime { get; }
```
Серверная дата записи изменения

```cpp
string Login { get; }
```
Логин от имени которого произошло изменение

```cpp
string IpAddress { get; }
```
IP адрес ПК с котрого инициировалось изменение

```cpp
int PersonId { get; }
```
Идентификатор изменяемого пользователя

```cpp
IReadOnlyList<IPersonChangeData> PersonChangeData { get; }
```
Данные об изменениях, содержащие наименование измененного поля, его старое и новое значения

<a name="IMetricsEvents"/>
### Интерфейс IMetricsEvents ###

Данный интерфейс предоставляет события для отслеживания метрик Pilot-Server

```cpp
event EventHandler<ConnectionCountChangedEventArgs> ConnectionCountChanged;
```
Событие об изменении количества клиентских подключений к Pilot-Server. Учитываются подключения от всех клиентов, в т.ч. Pilot-myAdmin и сторонние сервисы.

```cpp
event EventHandler<AuthEventArgs> OnUserAuth;
```
Событие уведомляет о аутентификации пользователя. В случае неуспешной аутентификации в аргументах события свойство IsSuccess будет установлено в false и заполнено свойство Exception.

```cpp
event EventHandler<AuthEventArgs> OnAdministratorAuth;
```
Событие уведомляет о аутентификации администратора Pilot-Server. В случае неуспешной аутентификации в аргументах события свойство IsSuccess будет установлено в false и заполнено свойство Exception.

```cpp
event EventHandler<SessionEventArgs> OnSessionClosed;
```
Событие уведомляет о завершении пользовательской сессии. Дальшейшая работа пользователя или администратора будет возможна только после повторной аутентификации.

```cpp
event EventHandler<ChangesetEventArgs> OnChangeset;
```
Событие уведомляет о новом статусе набора изменений. Наборы изменений используются для изменения объектов Pilot и являются атомарными (либо все изменения набора будут приняты сервером, либо весь набор изменений будет отклонен). 
> Члены класса аргументов события ChangesetEventArgs:

> ```cpp
> Guid ChangesetIdentity { get; }
> ```
> Идентификатор набора изменений

> ```cpp
> ChangesetStatus Status { get; }
> ```
> Статус набора изменений. Enqueued - добавлен в очередь на обработку, Completed - успешно обработан, Error - не принят сервером (см. ошибку в ChangesetEventArgs.Error).

> ```cpp
> Exception Error { get; }
> ```
> Ошибка при применении набора изменений. Заполнена только в случае, если статус набора изменений Error.

```cpp
event EventHandler<LicenseEventArgs> LicenseConsumed;
```
Событие уведомляет об успешном взятии лицензии пользователем.

```cpp
event EventHandler<LicenseConsumeErrorEventArgs> LicenseConsumeError;
```
Событие уведомляет об ошибке при взятии лицензии пользователем.

```cpp
event EventHandler<LicenseEventArgs> LicenseReleased;
```
Событие уведомляет о том, что взятая ранее лицензия была освобождена.

<a name="IAutomationSearchService"/>
### Интерфейс IAutomationSearchService ###

```cpp
var searchService = serverActivityContext.GetService<IAutomationSearchService>();
```
Сервис `IAutomationSearchService` служит для поиска объектов. Порядок работы с интерфейсом `IQueryBuilder` описан в документации ** Ascon Pilot Server SDK **

Метод поиска объектов.
```cpp
IEnumerable<Guid> Search(IQueryBuilder queryBuilder, int maxResults = int.MaxValue);
```
где:
  - `queryBuilder` - конструктор запроса;
  - `maxResults` - ограничение на количество возвращаемых результатов;

Пример использования:
```cpp
using System;
using System.Linq;
using System.Collections;
using System.Threading.Tasks;
using System.Collections.Generic;
using System.ComponentModel.Composition;
using Ascon.Pilot.ClientCore.Search;
...

namespace SearchActivitySample
{
	[Export(typeof(IServerActivity))]
    public class SearchActivity : IServerActivity
    {
        public string Name => "SearchActivity";
    	...
        public Task RunAsync(IModifierBase modifier, IModifierBackend backend, IServerActivityContext serverActivityContext, IAutomationEventContext automationEventContext)
        {
            var searchService = serverActivityContext.GetService<IAutomationSearchService>();
            var queryBuilder = QueryBuilderFactory.CreateEmptyQueryBuilder();
            // пример поиска проектов, где указан контрагент
            queryBuilder.Must(AttributeFields.String("Contractor_name").Exists());
            IEnumerable<Guid> objectsWithContractors = searchService.Search(queryBuilder);
            ...
            return Task.CompletedTask;
		}
	}
}
```
<a name="IServerApiFactory"/>
### Интерфейс IServerApiFactory ###
Интерфейс IServerApiFactory предназначен для регистрации дополнительных контрактов для клиент-серверного взаимодействия. Принцип работы с IServerApiFactory демонстрируется в примере Server\Extensions\Samples\ServerApiFactory.ServerExtension.