﻿using Ascon.Pilot.DataModifier;
using Ascon.Pilot.ServerExtensions.SDK;
using System.Collections.Concurrent;
using System.ComponentModel.Composition;
using ServerApiFactory.Contracts;

namespace ServerApiFactory.ServerExtension
{
    [Export(typeof(IServerApiFactory))]
    public class ServerApiFactory : IServerApiFactory, ICustomServerCallback
    {
        private readonly MessagesStorage _storage = new MessagesStorage();
        private readonly ConcurrentDictionary<ServerSession, ICustomServerCallback> _callbacks = new ConcurrentDictionary<ServerSession, ICustomServerCallback>();

        public bool TryCreate(string interfaceName, IServerApiServiceContainer container, out object api)
        {
            if(interfaceName != nameof(ICustomServerContract))
            {
                api = default;
                return false;
            }               

            var backend = container.GetService<IModifierBackend>();
            var callbackFactory = container.GetService<ISessionCallbackFactory>();
            var callback = callbackFactory.Create<ICustomServerCallback>();
            var session = new ServerSession(backend, _storage, this, s => _callbacks.TryRemove(s, out _));
            _callbacks[session] = callback;
            api = session;
            return true;
        }

        public void OnMessageAdded(Message message)
        {
            foreach (var callback in _callbacks)
            {
                callback.Value.OnMessageAdded(message);
            }
        }
    }
}
