/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.IO;

namespace Pilot.Xps.Domain.Context
{
    class DirectoryProvider
    {
        private static string CurrentDirectory => AppDomain.CurrentDomain.BaseDirectory;

        public static string GetTempDirectory()
        {
            var directory = Path.Combine(CurrentDirectory, "tmp");
            if (!Directory.Exists(directory))
                Directory.CreateDirectory(directory);

            return directory;
        }
    }
}
