/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Threading.Tasks;
using Ascon.Pilot.Server.Api.Contracts;
using Ascon.Pilot.Transport;

namespace Pilot.Xps.Connection.Client
{
    public class ServerCommandCallService<T> : ICallService
    {
        private readonly IRepository _repository;
        private readonly string _commandName;
        
        public ServerCommandCallService(IRepository repository, string processorName = null)
        {
            _repository = repository;
            _commandName = CommandNameParser.GetCommandName(typeof(T).Name, processorName);
        }

        public byte[] Call(ICallData data)
        {
            var result = _repository.InvokeServerCommand(_commandName, data.GetBytes())
                .GetAwaiter()
                .GetResult();

            switch (result.Result)
            {
                case ServerCommandResult.Success:
                    return result.Data;
                case ServerCommandResult.Error:
                    throw TransportClient.ReadException(result.Data);
                default:
                    throw new InvalidOperationException("Unable to deserialize server command response");
            }
        }

        public Task<byte[]> CallAsync(ICallData data)
        {
            throw new NotImplementedException();
        }

        public byte[] Get(string data)
        {
            throw new NotImplementedException();
        }
    }
}
